# coding:utf-8
from __future__ import absolute_import
from celery import Celery
from django.apps import apps
import os, django

os.environ.setdefault("DJANGO_SETTINGS_MODULE", "etc.settings.local")

django.setup()
# 创建celery应用对象
app = Celery("console")
# 导入celery的配置信息
app.config_from_object("django.conf:settings", namespace="CELERY")
# 导入所有app
installed_apps = [app_config.name for app_config in apps.get_app_configs()]
# 自动发现app下面的tasks 文件
app.autodiscover_tasks(lambda: installed_apps, force=True)
