#!/usr/bin/env python
# -*- coding: utf-8 -*-
from collections import OrderedDict

from rest_framework.pagination import PageNumberPagination
from rest_framework.response import Response

from common.utils.service_code import INFO_CODE


class CustomPageNumberPagination(PageNumberPagination):

    page_size_query_param = 'page_size'
    page_query_param = 'page'
    page_size = 10

    def get_paginated_response(self, data):
        rst = {"bean": {}, "list": []}
        rst["list"] = data
        return Response(
            OrderedDict([('count', self.page.paginator.count),
                         ('page', self.page.number),
                         ('page_size', self.page.paginator.per_page),
                         ('code', INFO_CODE), ('msg', 'success'),
                         ('msg_show', '获取列表成功'), ('data', rst)]))

    def get_paginated_response_schema(self, schema):
        return {
            'type': 'object',
            'properties': {
                'count': {
                    'type': 'integer',
                    'example': 123,
                },
                'page': {
                    'type': 'integer',
                    'example': 1,
                },
                'num_pages': {
                    'type': 'integer',
                    'example': 5,
                },
                'page_size': {
                    'type': 'integer',
                    'example': 10,
                },
                'data': schema,
            },
        }
