import os
import datetime
from dateutil.relativedelta import relativedelta
from etc.celery import app
from django.conf import settings


@app.task(bind=True)
def debug_task(_):
    print("hello world")


# 按日期分割celery日志
@app.task(bind=True)
def shard_log(_):
    log_path = settings.LOG_PATH
    log_file = os.path.join(log_path, 'celery.log')
    day = datetime.date.today() - relativedelta(days=+1)
    new_file = os.path.join(log_path, "celery-%s.log" % day)
    if not os.path.exists(log_file):
        try:
            os.mknod(log_file)
        except Exception:
            pass
    if not os.path.exists(new_file):
        os.rename(log_file, new_file)
        try:
            os.mknod(log_file)
        except Exception:
            pass
