#!/usr/bin/env python
# -*- coding: utf-8 -*-
import logging

from django.shortcuts import render
from drf_yasg.utils import swagger_auto_schema

from common.utils.views import AllowAnyApiView
from apps.log.services import log_service

logger = logging.getLogger('')


class LogsLView(AllowAnyApiView):
    @swagger_auto_schema(
        operation_description="""
        ### 日志
        """,
        tags=['Logs'],
    )
    def get(self, request, *args, **kwargs):
        data = log_service.get_logs()
        context = {"logs":data}
        return render(request, "log.html", context)
