import React, { memo } from 'react';
import { useSize } from '@umijs/hooks';
import Map from './Map';
import MonthTotal from './MonthTotal';
import RealTimeData from './RealTimeData';
import Inspection from './Inspection';
import TabPanel from './TabPanel';
import ScreenHeader from './ScreenHeader';
import styles from './index.less';
import TrustEnergy from './TrustEnergy';
import Microgrid from './Microgrid';
import { connect } from 'dva';
import { featureEnum } from '@/pages/screen/constants';

const WIDTH = 3840;
const HEIGHT = 2160;

const Screen = ({features}) => {
  const [{ width, height }] = useSize(window.document.body);
  const rate = (width / height).toFixed(2)
  const W_WIDTH = rate * HEIGHT;
  const scaleY = height / HEIGHT;
  const style = {
    width: W_WIDTH,
    height: HEIGHT,
    transform: `scale(${scaleY})`,
    transformOrigin: 'left top',
    overflow: 'hidden'
  };

  return (
    <div style={{width, height, position: 'relative', overflow: 'hidden'}} className="normal-screen">
      <div style={style} className={`${styles.content} ${styles.contentNormal}`}>
        <ScreenHeader isNormal={true} />
        <div className={styles.body}>
          <div className={styles.left}>
            <TrustEnergy isNormal={true} />
            <MonthTotal isNormal={true} />
            <RealTimeData isNormal={true} />
            <Inspection isNormal={true} />
          </div>
          <div className={styles.center}>
            <Map isNormal={true} scale={scaleY} />
          </div>
          <div className={styles.right}>
            {
              features.includes(featureEnum.eleNet)
                ? <Microgrid isNormal={true}/>
                : <TabPanel isNormal={true}/>
            }
          </div>
        </div>
        <div className={styles.bg}></div>
      </div>
    </div>
  );
}

export default connect(({screen}) => {
  const {features} = screen;
  return {
    features
  }
})(memo(Screen))
