import { useState } from 'react';

export default function usePagination(data = []) {
  const defaultPage = 1;
  const pageSize = 10;
  const [page, setPage] = useState(defaultPage);
  const start = (page - 1) * pageSize;
  const end = page * pageSize;
  const list = data.slice(start, end);
  const pagination = {
    page,
    pageSize,
    total: data.length,
    // hideOnSinglePage: true,
    showSizeChanger: false,
    size: 'small',
    onChange(v) {
      setPage(v);
    },
  };
  return [list, pagination];
}
