/**
 * @file 折线图
 * @author  yangzhong01
 * @date 2021/4/28
 */

import React, {memo} from 'react';
import ReactEchartsCore from 'echarts-for-react/lib/core';
import echarts from 'echarts/lib/echarts';
import 'echarts/lib/component/tooltip';
import 'echarts/lib/component/grid';
import 'echarts/lib/chart/bar';

export default memo(props => {
  const {xAxis, yAxis, series, title, style, grid} = props;
  const localOpts = {
    title: {
      show: true,
      text: 'title',
      textStyle: {
        color: '#fff',
        fontSize: 14
      },
      ...title
    },
    xAxis: {
      type: 'category',
      axisLine: {
        lineStyle: {
          color: '#fff'
        }
      },
      splitLine: {
        show: false
      },
      ...xAxis
    },
    yAxis: {
      type: 'value',
      axisLine: {
        lineStyle: {
          color: '#fff'
        }
      },
      splitLine: {
        show: true,
        lineStyle: {
          color: '#fff',
          opacity: 0.5
        }
      },
      ...yAxis
    },
    tooltip: {
      trigger: 'axis'
    },
    grid: {
      left: '3%',
      right: '4%',
      bottom: '5%',
      containLabel: true,
      ...grid
    },
    series: series.map(item => ({color: '#FC6C4F', barWidth: 4, ...item, type: 'bar'})),
  };

  return (
    <ReactEchartsCore
      echarts={echarts}
      option={localOpts}
      notMerge={true}
      lazyUpdate={true}
      style={style}
    />
  );
})
