import React, {useState} from 'react';
import {
  CaretDownOutlined,
  CaretLeftOutlined
} from '@ant-design/icons';
import classNames from 'classnames';
import styles from './index.less';

export default ({value, options = [], theme='blue', onSelect = () => {}, direction='down', isNormal, className}) => {
  const wrapClass = classNames(
    styles.monthWrap,
    {
      [styles.monthOrange]: theme === 'orange',
      [styles.monthUp]: direction === 'up',
      [styles.mothWrapNormal]: isNormal,
      [className]: className,
    }
  );
  const selected = options.find(item => item.value === value)
  return <div className={wrapClass}>
    <span className={styles.selectedMonth}>
      {selected && selected.label}
    </span>
    <span className={styles.caretDown}><CaretDownOutlined /></span>
    <span className={styles.caretLeft}><CaretLeftOutlined /></span>
    <div className={styles.monthList}>
      {options.map((item, index) => (
        <div
          className={classNames(
            {
              [styles.monthActiveItem]: value == item.value,
              [styles.monthItem]: value != item.value
            }
          )}
          onClick={() => onSelect(item)}
          key={index}
        >
          {`${item.label}`}
        </div>
      ))}
    </div>
  </div>;
};
