import React from 'react';
import ReactEchartsCore from 'echarts-for-react/lib/core';
import echarts from 'echarts/lib/echarts';
import 'echarts/lib/chart/pie';
import 'echarts/lib/component/tooltip';
import 'echarts/lib/component/grid';
import styles from './index.less';

const ThemeColorMap = {
  orange: '255, 112, 78',
  blue: '50, 212, 214',
  default: '50, 212, 214'
}

const Padding = 10;
// const BorderColor = '#ff714e';

export default class RadarCanvas extends React.Component {

  getColor = (a = 1) => {
    const color = ThemeColorMap[this.props.theme];
    return `rgba(${color}, ${a})`
  }

  getOption = () => {
    const {percent} = this.props;

    return {
      legend: {
          show:false
      },
      backgroundColor: 'transparent',
      animation: true,
      series: [
          {
              name: 'a',
              type: 'pie',
              radius: ['80%', '100%'],
              label: {
                  show: false
              },
              labelLine: {
                  show: false
              },
              itemStyle: {
                  color: this.getColor('.3'),
                  borderWidth: 0
              },
              hoverOffset: 0,
              data: [
                  {value: 100, name: 'a'}
              ]
          },
          {
              name: 'b',
              type: 'pie',
              radius: ['90%', '100%'],
              label: {
                  show: false
              },
              labelLine: {
                  show: false
              },
              itemStyle: {
                  borderWidth: 0
              },
              animationType: "expansion",
              animationDelay: function (idx) {
                // 越往后的数据延迟越大
                return idx * 100;
              },
              hoverOffset: 0,
              data: [
                  {
                    value: percent * 100,
                    name: 'b1',
                    itemStyle: {
                      color: this.getColor()
                    }
                  },
                  {
                    value: 100 - percent * 100,
                    name: 'b2',
                    itemStyle: {
                      color: 'transparent'
                    }
                  }
              ]
          },
          {
            name: 'e',
            type: 'pie',
            label: {
                show: false
            },
            labelLine: {
                show: false
            },
            itemStyle: {
              borderWidth: 0
            },
            radius: ['8%', '10%'],
            hoverOffset: 0,
            data: [
                {
                  value: percent * 100,
                  name: 'c1',
                  itemStyle: {
                    color: this.getColor('.2')
                  }
                }
            ]
        },
          {
              name: 'c',
              type: 'pie',
              label: {
                  show: false
              },
              labelLine: {
                  show: false
              },
              itemStyle: {
                borderWidth: 0
              },
              radius: ['0%', '100%'],
              hoverOffset: 0,
              data: [
                  {
                    value: percent * 100,
                    name: 'c1',
                    itemStyle: {
                      color: this.getColor('.2')
                    }
                  },
                  {
                    value: 100 - percent * 100,
                    name: 'c2',
                    itemStyle: {
                      color: 'transparent'
                    }
                }
              ]
          },
          {
            name: 'd',
            type: 'pie',
            label: {
                show: false
            },
            labelLine: {
                show: false
            },
            itemStyle: {
              borderWidth: 0
            },
            radius: ['15%', '20%'],
            hoverOffset: 0,
            data: [
                {
                  value: percent * 100,
                  name: 'c1',
                  itemStyle: {
                    color: this.getColor('.2')
                  }
                },
                {
                  value: 100 - percent * 100,
                  name: 'c2',
                  itemStyle: {
                    color: 'transparent'
                  }
              }
            ]
        }
      ]
    };
  }

  getStyle = () => {
    return {
      // border: `1px solid ${this.getColor()}`,
      // overFlow: 'hidden',
      // borderRadius: '50%',
      padding: Padding,
      position: 'relative'
    }
  }

  turnToNum = str => {
    return +String(str).replace('px', '');
  }

  getScrollLineStyle = () => {
    const {width = 200, height = 200} = this.props;

    return {
      width: `${this.turnToNum(width)/2 + Padding}px`,
      height: `${this.turnToNum(height)/2 + Padding}px`,
      borderColor: this.getColor()
    };
  }

  render() {
    const {width, height} = this.props;
    return <div style={this.getStyle()}>
      <div className={styles.scrollLine} style={this.getScrollLineStyle()}></div>
      <div className={styles.scrollLineRight} style={this.getScrollLineStyle()}></div>
        <ReactEchartsCore
          echarts={echarts}
          option={this.getOption()}
          notMerge={true}
          lazyUpdate={true}
          style={{height, width}}
        />
    </div>
  }
}
