import React, {useState} from 'react';
import {
  CaretDownOutlined,
  CaretLeftOutlined
} from '@ant-design/icons';
import classNames from 'classnames';
import styles from './index.less';

const monthList = ['一', '二', '三', '四', '五', '六', '七', '八', '九', '十', '十一', '十二'];

export default ({value, theme='blue', onSelect = () => {}, direction='down', isNormal}) => {
  const wrapClass = classNames(
    styles.monthWrap,
    {
      [styles.monthOrange]: theme === 'orange',
      [styles.monthUp]: direction === 'up',
      [styles.mothWrapNormal]: isNormal
    }
  );
  return <div className={wrapClass}>
    <span className={styles.selectedMonth}>
      {monthList[value] + '月'}
    </span>
    <span className={styles.caretDown}><CaretDownOutlined /></span>
    <span className={styles.caretLeft}><CaretLeftOutlined /></span>
    <div className={styles.monthList}>
      {monthList.map((item, index) => (
        <div
          className={classNames(
            {
              [styles.monthActiveItem]: value == index,
              [styles.monthItem]: value != index
            }
          )}
          onClick={() => onSelect(index)}
          key={index}
        >
          {`${item}月`}
        </div>
      ))}
    </div>
  </div>;
};
