import React, { memo, useEffect, useMemo, useState } from 'react';
import classNames from 'classnames';

import styles from './index.less';

export default memo((
  {
    paused = false,
    text = '平台接入中'
  }
) => {
  const [i, setIndex] = useState(0);
  useEffect(() => {
    let a = 0;
    let timer = setInterval(fn, 250);
    function fn () {
      a ++
      const index = a % text.length;
      clearInterval(timer);
      if (index < text.length - 1) {
        timer = setInterval(fn, 250);
      }
      else {
        timer = setInterval(fn, 1000);
      }
      setIndex(index);
    }
    return () => {
      clearInterval(timer);
    }
  }, [])

  return <div className={styles.comingSoonText}>
    {text.split('').map((item, index) => (
      <span key={index} className={classNames(styles.item, {[styles.active]: i === index})}>{item}</span>
    ))}
  </div>
})
