import React from 'react';
import cls from 'classnames';
import { Modal } from 'antd';
import styles from './index.less';

export default function AntdModal({
  className,
  children,
  onClose,
  ...otherProps
}) {
  const props = {
    footer: null,
    mask: false,
    visible: true,
    ...otherProps,
  }
  return (
    <Modal maskClosable={false} className={cls(styles.modal, className)} {...props} onCancel={onClose}>
      {children}
    </Modal>
  );
}
