import React, { useState, useEffect } from 'react';
import get from 'lodash/get';
import classNames from 'classnames';
import { getWeather } from '@/pages/screen/services';
import styles from './index.less';

export default React.memo(({isNormal}) => {
  const [weather, setWeather] = useState('-');
  useEffect(() => {
    getWeather().then(res => {
      setWeather(get(res, 'data.bean.weather', '-'))
    })
  }, [])
  const wrapClassNames = classNames(styles.screenHeader, {
    [styles.screenHeaderNormal]: isNormal
  })
  return <div className={wrapClassNames}>
    <div className={styles.titleText}>指挥调度数据中心</div>
    <div className={styles.today}>
      {`${new Date().getFullYear()}.${new Date().getMonth() + 1}.${new Date().getDate()} | ${weather}`}
    </div>
  </div>
});
