/**
 * 实时数据统计
 */

import React, { useCallback } from 'react';
import CountTo from 'react-count-to';
import { connect } from 'dva';
import classNames from 'classnames';
import ReactEchartsCore from 'echarts-for-react/lib/core';
import echarts from 'echarts/lib/echarts';
import 'echarts/lib/chart/pictorialBar';
import 'echarts/lib/component/tooltip';
import 'echarts/lib/component/grid';
import BigData from '../components/BigData';
import styles from './index.less';
import account from '../../../resource/images/screen/account.png';
import power_station from '../../../resource/images/screen/power_station.png';
import equipment from '../../../resource/images/screen/equipment.png';
import charge from '../../../resource/images/screen/charge.png';
import {LeftUrlMap} from '../constants';

const RealDataItem = ({title, num, img, data = [], isNormal, url}) => {
  const getOption = () => ({
    xAxis: {
      type: 'category',
      show: false,
      data: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12']
    },
    grid: {
      show: false
    },
    yAxis: {
      show: false,
      type: 'value'
    },
    series: [{
        data,
        type: 'pictorialBar',
        symbol: 'rect',
        symbolSize: ['100%', 5],
        color:'#32D4D6',
        symbolRepeat: true,
        symbolBoundingData: 100,
        itemStyle: {
          color: '#32D4D6',
          barBorderRadius: 2
        }
    }]
  });

  const wrapClassNames = classNames(styles.realTimeItem, {
    [styles.realTimeItemNormal]: isNormal
  });

  const echartsStyles = {
    height: isNormal ? '170px' : '38px',
    width: isNormal ? '300px' : '210px'
  };

  const fn = val => <BigData num={val} size="normal" isNormal={isNormal} />

  const onItemClick = useCallback(() => {
    window.open(url);
  }, [url]);

  return (
    <div className={wrapClassNames} style={{cursor: 'pointer'}} onClick={onItemClick}>
      <div className={styles.itemImgWrap}>
        <img src={img} className={styles.itemImg}/>
      </div>
      <div className={styles.realTimeCenter}>
        <div className={styles.itemTitle}>{title}</div>
        <div>
          <CountTo to={num} speed={5000}>{fn}</CountTo>
        </div>
      </div>
      {/* <div>
        <ReactEchartsCore
          echarts={echarts}
          option={getOption()}
          notMerge={true}
          lazyUpdate={true}
          style={echartsStyles}
          />
      </div> */}
    </div>
  );
};

@connect(({ overview, screen }) => ({ ...overview, company: screen.company, area: screen.area}))
export default class RealTimeData extends React.PureComponent {
  componentDidMount() {
    const {dispatch, company, area} = this.props;
    dispatch({
      type: 'overview/fetchRealTimeData',
      payload: {
        enterprise_id: company,
        province: area[0],
        city: area[1]
      }
    })
  }
  render() {
    const {realData, isNormal} = this.props;
    const wrapClassNames = classNames(styles.realTime, {
      [styles.realTimeNormal]: isNormal
    });

    return <div className={wrapClassNames}>
      <div className={styles.title}>实时数据统计</div>
      <RealDataItem
        title="户数"
        data={realData.list1}
        num={realData.number_count || 0}
        img={account}
        isNormal={isNormal}
        url={LeftUrlMap.account}
      />
      <RealDataItem
        title="电站数"
        data={realData.list2}
        num={realData.station_count || 0}
        img={power_station}
        isNormal={isNormal}
        url={LeftUrlMap.station}
      />
      <RealDataItem
        title="监测点位数"
        data={realData.list3}
        num={realData.monitor_device_count || 0}
        img={equipment}
        isNormal={isNormal}
        url={LeftUrlMap.monitor}
      />
      <RealDataItem
        title="装接容量（kVA）"
        data={realData.list4}
        num={realData.capacity_count || 0}
        img={charge}
        isNormal={isNormal}
        url={LeftUrlMap.capacity}
      />
    </div>
  }
}
