/**
 * @file 微电网
 * @author  yangzhong01
 * @date 2021/4/24
 */
import React, { memo } from 'react';
import { connect } from 'dva';
import {pick} from 'lodash';
import classNames from 'classnames';
import ChartsMain from './components';

import MonthEnergyFees from './components/MonthEnergyFees';
import styles from './index.less';

const {rightWrap, normalScreen} = styles;

export default connect(({overview}) => pick(overview, [
  'monthEnergyFees',
  'historyTrustEnergyFees',
  'photovoltaic',
  'energyStorage',
  'chargingPile',
  'lateLy30Charging'
]))(memo(props => {
  const {
    monthEnergyFees,
    historyTrustEnergyFees,
    photovoltaic,
    energyStorage,
    chargingPile,
    lateLy30Charging,
    isNormal,
    dispatch
  } = props;

  // mock 数据增长
  const autoIncreaseRightMock = () => dispatch({type: 'overview/autoIncreaseRightMock'});
  const wrapCls = classNames(rightWrap, {[normalScreen]: isNormal})
  const fetchRealData = () => dispatch({type: 'overview/fetchRealPLData'})

  return (
    <div className={wrapCls}>
      <MonthEnergyFees
        monthEnergyFees={monthEnergyFees}
        historyTrustEnergyFees={historyTrustEnergyFees}
        autoIncreaseRightMock={autoIncreaseRightMock}
        isNormal={isNormal}
      />
      <ChartsMain {...props} fetchRealData={fetchRealData}/>
    </div>
  );
}))

