/**
 * @file 光伏
 * @author  yangzhong01
 * @date 2021/4/24
 */
import React, { memo, useEffect } from 'react';
import { Progress } from 'antd';
import withClickCell from '../withClickCell';
import LiquidFillBox from '../LiquidFillBox';
import LineStack from '../../../components/echarts/line';
import styles from './index.less';

const {flexLine, leftText, rightText, bottomLine, normalScreen} = styles;

const RealTimeData = props => {
  const {realTimePowerList, isNormal} = props;
  const data = realTimePowerList.map(item => item.time);
  const series = realTimePowerList.map(item => item.value);
  const h = isNormal ? 210 : 165;
  return (
    <LineStack
      title={{text: "光伏发电功率"}}
      xAxis={{data}}
      yAxis={{name: 'kw'}}
      series={[{data: series, itemStyle: {color: '#3CD5D4'}, lineStyle: {color: '#3DD6D5'}}]}
      style={{height: h, marginTop: 10}}
    />
  );
}

const TotalPhotovoItaic = props => {
  const {
    totalPower = 0,
    totalAssemblyCapacity,
    realTimePowerList = [],
    isNormal
  } = props;
  return (
    <div>
      <div className={flexLine}>
        <span className={leftText}>{totalPower}</span>
        <span className={rightText}>{totalAssemblyCapacity}</span>
      </div>
      <Progress status="active" showInfo={false} strokeColor="#21C2C5" percent={50} trailColor="#335F5F" />
      <div className={`${flexLine} ${bottomLine}`}>
        <span className={leftText}>总功率（kW）</span>
        <span className={rightText}>总装接容量（kWp）</span>
      </div>
      <RealTimeData realTimePowerList={realTimePowerList} isNormal={isNormal}/>
    </div>
  )
};

export default memo(props => {
  const {total, realTimePowerList, totalAssemblyCapacity,
    realTimePowerGeneration, totalPower, isNormal, fetchRealData, isModal} = props;

  useEffect(() => {
    if (!fetchRealData) {
      return;
    }
    const time = new Date();
    const distance = time.getMinutes() * 60 + time.getSeconds();
    let t1 = null;
    let t2 = null;
    fetchRealData();
    if (distance) {
      t1 = setTimeout(() => {
        fetchRealData()
        t2 = setInterval(() => {
          fetchRealData()
        }, 60 * 60 * 1000);
      }, distance * 1000);
    }
    else {
      t2 = setInterval(() => {
        fetchRealData()
      }, 60 * 60 * 1000);
    }

    return () => {
      clearTimeout(t1);
      clearInterval(t2);
    };
  }, [])
  const FrontSide = memo(() => (
    <LiquidFillBox
      top={{attr: '总装接容量', num: totalAssemblyCapacity, unit: 'kWp'}}
      bottom={{attr: '实时发电功率', num: realTimePowerGeneration, unit: 'kW'}}
      horizontal={isNormal}
    />
  ));

  const BackSide = memo(() => (
    <div>
      <TotalPhotovoItaic
        totalPower={totalPower}
        totalAssemblyCapacity={totalAssemblyCapacity}
        realTimePowerList={realTimePowerList}
        isNormal={isNormal}
      />
    </div>
  ));


  const PhotoItalic = withClickCell(FrontSide, BackSide)
  return <PhotoItalic
    category="光伏"
    attr="累计总发电量（kWh）"
    value={total}
    isNormal={isNormal}
    className={isNormal ? normalScreen : ''}
    hasBottomBorder={isNormal}
  />
});
