/**
 * @file 月累计数据
 * @author  yangzhong01
 * @date 2021/4/27
 */
import React, { memo, useEffect, useState, useRef } from 'react';
import classNames from 'classnames';
import styles from './index.less';
import { ColorNum } from '@/pages/screen/components/BigData';
import CountTo from 'react-count-to';

export default memo(props => {
  const {wrapper, content, title, label, num, line, normalScreen} = styles;
  const {monthEnergyFees, historyTrustEnergyFees, autoIncreaseRightMock, isNormal} = props;
  const numSize = isNormal ? '36' : '25';
  const [flag, setFlag] = useState(false);

  const prevHistoryRef = useRef();
  useEffect(() => {
    prevHistoryRef.current = historyTrustEnergyFees;
  });

  const prevMonthRef = useRef();
  useEffect(() => {
    prevMonthRef.current = monthEnergyFees;
  });


  useEffect(() => {
    if (flag) {
      return;
    }
    setFlag(true);
    const interval = setInterval(() => {
      autoIncreaseRightMock();
    }, 10000)

    // 清理定时器
    return function clearTimer() {
      clearInterval(interval);
    }
  }, [])

  const fn = val => (
    <ColorNum
      color="orange"
      num={val}
      size={numSize}
      italic={true}
      shadow={false}
      toFixed={0}
    />
  )
  const fn2 = val => (
    <ColorNum
      color="orange"
      num={val}
      size={numSize}
      italic={true}
      shadow={false}
      toFixed={0}
    />
  )
  const wrapCls = classNames(wrapper, {
    [normalScreen]:isNormal
  });

  return (
    <div className={wrapCls}>
      <div className={title}>微电网</div>
      <div className={content}>
        <div className={line}>
          <span className={label}>本月新能源产生电费（元）：</span>
          <CountTo from={prevMonthRef.current} to={monthEnergyFees} speed={1000}>{fn}</CountTo>
        </div>
        <div className={line}>
          <span className={label}>累计新能源产生电费（元）：</span>
          <CountTo from={prevHistoryRef.current} to={historyTrustEnergyFees} speed={1000}>{fn2}</CountTo>
        </div>
      </div>
    </div>
  );
});
