/**
 * @file
 * @author  yangzhong01
 * @date 2021/4/28
 */
import React, {memo} from 'react';
import classNames from 'classnames';
import LiquidFill from '../../../components/LiquidFill';
import styles from './index.less';
import { ColorNum } from '@/pages/screen/components/BigData';

const defSeries = {
  type: 'liquidFill',
  data: [0.5],
  // 背景色
  backgroundStyle: {
    color: '#224647'
  },
  radius: '95%',
  // 外圈
  outline: {
    show: true,
    borderDistance: 8,
    itemStyle: {
      color: 'none',
      borderColor: '#179FA2',
      borderWidth: 2,
    }
  },
  itemStyle: {
    color: {
      type: 'linear',
      x: 0,
      y: 0,
      x2: 1,
      y2: 0,
      colorStops: [{
        offset: 0, color: '#319291' // 0% 处的颜色
      }, {
        offset: 1, color: '#285757' // 100% 处的颜色
      }],
      global: false // 缺省为 false
    }
  },
  label: {
    show: false
  }
};

export default memo(props => {
  const {
    top,
    bottom,
    horizontal = false,
    isModal = false
  } = props;
  const {
    wrapper,
    label,
    left,
    right,
    desc,
    topLabel,
    bottomLabel,
    num,
    unit,
    liquidContainer,
    circleIcon,
    attrBottom,
    attrTop,
    horizontalWrap
  } = styles;
  const wrapCls = classNames(wrapper, {[horizontalWrap]: horizontal})
  const liquidFillSize = isModal ? 150 : (horizontal ? 290 : 180);
  const numSize = horizontal ? 36 : 18;

  return (<div className={wrapCls}>
    <div className={liquidContainer}>
      <div className={label}>
        <div className={topLabel}>
          <ColorNum
            color="orange"
            num={top.num}
            size={numSize}
            shadow
            weight={400}
          />
          <div className={unit}>{top.unit}</div>
        </div>
        <div className={bottomLabel}>
          <ColorNum
            color="blue"
            num={bottom.num}
            size={numSize}
            shadow
            weight={400}
          />
          <div className={unit}>{bottom.unit}</div>
        </div>
      </div>
      <LiquidFill
        style={{width: liquidFillSize, height: liquidFillSize}}
        option={{series: [defSeries]}}
      />
    </div>
    <div className={right}>
      <div className={desc + ' ' + attrTop}>{top.attr}</div>
      <div className={desc + ' ' + attrBottom}>{bottom.attr}</div>
    </div>
  </div>)

});
