import React from 'react';
import cls from 'classnames';
import Modal from '../../components/Modal';
import { VehicleStatusMap } from '@/pages/screen/constants'
import { VehicleStatusEnum } from '../../constants'
import styles from './index.less';

export default React.memo(function Vehicle(props) {
  const gray = VehicleStatusEnum.offline === props.status
  return (
    <Modal className={'flex ' + styles.people}>
      <div className={styles.info}>
        <div className={styles.name}>{props.number_plate}</div>
        <div>名称：{props.name}</div>
        <div>车辆号：{props.number_plate || ''}</div>
        <div>方向：{props.direction}</div>
        <div>速度：{props.speed}</div>
        <div>状态：{VehicleStatusMap[props.status] || ''}</div>
      </div>
      <div className={cls(styles.avatar, { [styles.gray]: gray })} />
    </Modal>
  );
})
