import React from 'react';
import { Table, Tabs } from 'antd';
import cls from 'classnames';
import groupBy from 'lodash/groupBy';
import usePagination from '@/pages/screen/hooks/usePagination'
import Modal from '../../components/Modal';
import Button from '../../components/Button';
import {
  DispatchDataList,
  RunStatusMap,
  RunStatusEnum,
  PeopleStatusEnum,
  PeopleStatusMap,
  DispatchDataMap,
  VehicleStatusEnum,
  VehicleStatusMap,
} from '../../constants';
import styles from './index.less';

const { TabPane } = Tabs;

export default React.memo(function TableInfo({
  data = [],
  onMouseEnter = () => {},
  onMouseLeave = () => {},
  ...props
}) {
  const dataGroup = groupBy(data, 'type');
  const [customer, customerPagination] = usePagination(dataGroup[DispatchDataMap.customer]);
  const [vehicle, vehiclePagination] = usePagination(dataGroup[DispatchDataMap.vehicle]);
  const [people, peoplePagination] = usePagination(dataGroup[DispatchDataMap.people]);
  const customerColumns = [
    // {
    //   title: 'ID',
    //   dataIndex: 'id',
    //   key: 'id',
    //   width: 60,
    //   render(_, a, index) {
    //     return index
    //   }
    // },
    {
      title: '户号',
      dataIndex: 'number',
      key: 'number',
      width: 135,
    },
    {
      title: '客户',
      dataIndex: 'name',
      key: 'name',
    },
    // {
    //   title: '状态',
    //   dataIndex: 'status',
    //   key: 'status',
    //   width: 60,
    //   render(key, record, index) {
    //     const isError = key === RunStatusEnum.error;
    //     return (
    //       <span className={cls({ [styles.error]: isError })} key={index}>
    //         {RunStatusMap[key]}
    //       </span>
    //     );
    //   },
    // },
  ];
  const vehicleColumns = [
    {
      title: '名称',
      dataIndex: 'name',
      key: 'name',
      width: 190,
    },
    {
      title: '车辆号',
      dataIndex: 'number_plate',
      key: 'number_plate',
      width: 130,
    },
    {
      title: '方向',
      dataIndex: 'direction',
      key: 'direction',
    },
    {
      title: '速度',
      dataIndex: 'speed',
      key: 'speed',
    },
    // {
    //   title: '组长',
    //   dataIndex: 'team_headman_name',
    //   key: 'team_headman_name',
    // },
    {
      title: '状态',
      dataIndex: 'status',
      key: 'status',
      width: 60,
      render(key) {
        const isError = key === VehicleStatusEnum.offline;
        return (
          <span className={cls({ [styles.error]: isError })}>
            {VehicleStatusMap[key]}
          </span>
        );
      },
    },
  ];
  const peopleColumns = [
    {
      title: '姓名',
      dataIndex: 'name',
      key: 'name',
    },
    {
      title: '电话',
      dataIndex: 'phone',
      key: 'phone',
      width: 140,
    },
    // {
    //   title: '班组',
    //   dataIndex: 'group',
    //   key: 'group',
    // },
    {
      title: '状态',
      dataIndex: 'status',
      key: 'status',
      render(key) {
        const isError = key === PeopleStatusEnum.error;
        return (
          <span className={cls({ [styles.error]: isError })}>
            {PeopleStatusMap[key] || '-'}
          </span>
        );
      },
    },
  ];
  const onRow = (record) => {
    return {
      onClick: () => {
        props.clickTableInfoDetail(record)
      }
    }
  }

  return (
    <Modal
      className={cls('screen-table', styles.table)}
      onMouseEnter={onMouseEnter}
    >
      <Tabs defaultActiveKey={DispatchDataList[0].value}>
        {customer.length && (
          <TabPane
            tab={DispatchDataList[0].label}
            key={DispatchDataList[0].value}
          >
            <Table
              rowKey="id"
              onRow={onRow}
              columns={customerColumns}
              pagination={customerPagination}
              dataSource={customer}
              scroll={{ y: 200 }}
            />
          </TabPane>
        )}
        {vehicle.length && (
          <TabPane
            tab={DispatchDataList[1].label}
            key={DispatchDataList[1].value}
          >
            <Table
              rowKey="id"
              onRow={onRow}
              columns={vehicleColumns}
              pagination={vehiclePagination}
              dataSource={vehicle}
              scroll={{ y: 200 }}
            />
          </TabPane>
        )}
        {people.length && (
          <TabPane
            tab={DispatchDataList[2].label}
            key={DispatchDataList[2].value}
          >
            <Table
              rowKey="id"
              onRow={onRow}
              columns={peopleColumns}
              pagination={peoplePagination}
              dataSource={people}
              scroll={{ y: 200 }}
            />
          </TabPane>
        )}
      </Tabs>
    </Modal>
  );
});
