import React from 'react';
import { connect } from 'dva';
import { Progress } from 'antd';
import AntdModal from '../../components/AntdModal';
import Info from '../Customer/Info';
import styles from './index.less';
import { useRequest } from 'umi';
import * as services from '../../services';
import imgSafeRun from '../../../../resource/images/screen/status_saferun.png';
import imgWarning from '../../../../resource/images/screen/status_warning.png';
import imgBug from '../../../../resource/images/screen/status_bug.png';
import imgDDL from '../../../../resource/images/screen/status_ddl.png';
import imgCheckFenshu from '../../../../resource/images/screen/status_check_fenshu.png';
import imgCheckTime from '../../../../resource/images/screen/status_check_time.png';

export default connect(({ screen }) => ({
  runStatus: screen.runStatus
}))(React.memo(function RunStatus({ dispatch, runStatus }) {
  const onClose = () => dispatch({ type: 'screen/handleRunStatus', payload: '' });
  const { data: list } = useRequest(
    services.getSafeTool,
    {
      formatResult(res) {
        return res;
      },
    },
  );
  const show = !!runStatus;
  if (!show) {
    return null
  }
  return (
    <AntdModal className={styles.box} onClose={onClose} title="运行日志">
      <div className={styles.infoRow}>
        <Info
          img={imgSafeRun}
          label="安全运行/天"
          value="379"
        />
        <Info
          img={imgWarning}
          label="未解除告警/条"
          value="2"
        />
        <Info
          img={imgBug}
          label="未消除缺陷/条"
          value="1"
        />
        <Info
          img={imgDDL}
          label="电试到期"
          value="2021-12-31"
          valueStyle={{fontSize: 24}}
        />
      </div>
      <div className={styles.infoRow} style={{ justifyContent: 'space-around' }}>
        <Info
          img={imgCheckFenshu}
          className="flex-c"
          label="上次诊断：健康"
          value="23"
          unit="分"
          valueStyle={{color: '#4697EF'}}
        />
        <Info
          img={imgCheckTime}
          className="flex-c"
          label="距离上次诊断"
          value="90"
          unit="天"
          valueStyle={{color: '#FFAE32'}}
        />
      </div>
      <div className={styles.detail}>
        <div>
          <div className={styles.subTitle}>
            <div>站内安全基础设施</div>
            <Progress percent={70} size="small" strokeColor="#FEAD32" trailColor="#53575A" format={() => '42/51分'} />
          </div>
          <div className={styles.list}>
            <div className={styles.item}>
              <div className={styles.itemLabel}>安全工器具</div>
              <div className={styles.itemValue}>27/30</div>
            </div>
            <div className={styles.item}>
              <div className={styles.itemLabel}>站内基础设施</div>
              <div className={styles.itemValue}>15/21</div>
            </div>
          </div>
        </div>
        <div>
          <div className={styles.subTitle}>
            <div>站内设备</div>
            <Progress percent={70} size="small" strokeColor="#FEAD32" trailColor="#53575A" format={() => '49/60分'} />
          </div>
          <div className={styles.list}>
            <div className={styles.item}>
              <div className={styles.itemLabel}>关键设备运行状态</div>
              <div className={styles.itemValue}>33/36</div>
            </div>
            <div className={styles.item}>
              <div className={styles.itemLabel}>主要设备运行年限</div>
              <div className={styles.itemValue}>16/24</div>
            </div>
          </div>
        </div>
        <div>
          <div className={styles.subTitle}>
            <div>站内管理</div>
            <Progress percent={70} size="small" strokeColor="#FEAD32" trailColor="#53575A" format={() => '24/39分'} />
          </div>
          <div className={styles.list}>
            <div className={styles.item}>
              <div className={styles.itemLabel}>变配电站管理制度</div>
              <div className={styles.itemValue}>18/18</div>
            </div>
            <div className={styles.item}>
              <div className={styles.itemLabel}>年检报告</div>
              <div className={styles.itemValue}>3/9</div>
            </div>
            <div className={styles.item}>
              <div className={styles.itemLabel}>运营方式</div>
              <div className={styles.itemValue}>3/12</div>
            </div>
          </div>
        </div>
        <div>
          <div className={styles.subTitle}>
            <div>电力系统经济运行</div>
            <Progress percent={70} size="small" strokeColor="#FEAD32" trailColor="#53575A" format={() => '25/42分'} />
          </div>
          <div className={styles.list}>
            <div className={styles.item}>
              <div className={styles.itemLabel}>变配电站管理制度</div>
              <div className={styles.itemValue}>9/15</div>
            </div>
            <div className={styles.item}>
              <div className={styles.itemLabel}>年检报告</div>
              <div className={styles.itemValue}>10/12</div>
            </div>
            <div className={styles.item}>
              <div className={styles.itemLabel}>运营方式</div>
              <div className={styles.itemValue}>6/15</div>
            </div>
          </div>
        </div>
        <div>
          <div className={styles.subTitle}>
            <div>变配电站环境</div>
            <Progress percent={70} size="small" strokeColor="#FEAD32" trailColor="#53575A" format={() => '25/30分'} />
          </div>
          <div className={styles.list}>
            <div className={styles.item}>
              <div className={styles.itemLabel}>站内环境</div>
              <div className={styles.itemValue}>15/18</div>
            </div>
            <div className={styles.item}>
              <div className={styles.itemLabel}>站外环境</div>
              <div className={styles.itemValue}>10/12</div>
            </div>
          </div>
        </div>
      </div>
    </AntdModal>
  );
}))
