import React, { useCallback } from 'react';
import { Rate } from 'antd';
import Modal from '../../components/Modal';
import Button from '../../components/Button';
import cls from 'classnames';
import { PeopleStatusMap, PeopleStatusEnum } from '@/pages/screen/constants'
import styles from './index.less';

export default React.memo(function People(props) {
  const gray = PeopleStatusEnum.offline === props.status
  const onOpenVideo = useCallback(() => {
    props.getPeopleVideoUrl(props.user_id);
    props.showLiveVideo('people');
  }, [props.user_id]);
  return (
    <Modal className={'flex ' + styles.people}>
      <div className={styles.info}>
        <div className={styles.name}>{props.name}</div>
        <div className={styles.phone}>{props.phone}</div>
        {/*<div>角色：{props.role || '-'}</div>*/}
        <div>所在班组：{props.group}</div>
        <div>当前状态：{PeopleStatusMap[props.status] || '-'}</div>
        <div>
          电工等级：
          {/*<Rate disabled defaultValue={Math.min(5, props.rate)} />*/}
          <Rate disabled defaultValue={5} />
        </div>
        <div>技能：巡检运维，紧急抢修，光伏运维，储能运维，<span style={{color: '#666'}}>充电桩运维，驾照，loT调试</span></div>
        <Button style={{ marginTop: 8 }} onClick={onOpenVideo}>实时视频</Button>
      </div>
      <div className={cls(styles.avatar, { [styles.gray]: gray })} />
    </Modal>
  );
})
