import React from 'react';
import { createPortal } from 'react-dom';
import styles from './index.less'

export default class MapTools extends React.Component {

  render() {
    const box = document.querySelector('.amap-controls');
    const {isNormal, scale} = this.props;
    if (!box) {
      return null
    }
    const right = isNormal ? 920 : 720
    return createPortal(
      <div className={styles.box} style={{right: right * scale}}>
        <div className={styles.btnScale} onClick={this.props.handleScale}></div>
        <div className={styles.btnLocation} onClick={this.props.handleLocation}></div>
      </div>, box
    )
  }
}
