import React from 'react';
import { connect } from 'dva';
import { DispatchDataMap } from '@/pages/screen/constants';
import ASelect from '../../components/ASelect';

export default connect(({ screen }) => ({
  companyList: screen.companyList,
  area: screen.area
}))(
  React.memo(function Company(props) {
    const onChange = val => {
      props.dispatch({
        type: 'screen/filterCompany',
        payload: val,
      });
      props.dispatch({type: 'overview/fetchRealTimeData', payload: {
          enterprise_id: val,
          province: props.area[0],
          city: props.area[1]
        }})

    };
    return (
      <ASelect
        showSearch
        allowClear
        placeholder="集团"
        className="map-filter-company"
        onChange={onChange}
        options={props.companyList.map(item => ({ label: item.name, value: item.id }))}
      />
    );
  }),
);
