import React from 'react';
import { connect } from 'dva';
import { useRequest } from 'umi';
import get from 'lodash/get';
import AntdModal from '../../components/AntdModal';
import CircuitDiagramPreview from '../../CircuitDiagramPreview'
import { getCircuitItem } from '../../services/index'
import Container from '../../components/Container';
import styles from './index.less';

export default connect(({ screen }) => ({
  eleDiagram: screen.eleDiagram
}))(React.memo(function EleDiagram({ dispatch, eleDiagram }) {
  const onClose = () => dispatch({ type: 'screen/handleEleDiagram', payload: '' });
  const show = !!eleDiagram;
  if (!show) {
    return null
  }

  const number = get(eleDiagram, 'info.number');
  const stationId = get(eleDiagram, 'id');

  const { data, loading } = useRequest(
    () => getCircuitItem(stationId),
    {
      formatResult(res) {
        return get(res, 'data.list', []);
      },
    },
  );
  const drawData = get(data, '[0].draw')
  const isEmpty = !get(data, 'length') || !drawData
  return (
    <AntdModal className={styles.box} onClose={onClose}>
      <Container loading={loading} empty={isEmpty}>
        <CircuitDiagramPreview data={drawData} show stationId={stationId} number={number} />
      </Container>
      {/* <iframe className={styles.iframe} src="https://dtdx-xzhdwg3.as.digitwin.com.cn/#/xzhdwg/dwg-edit"/> */}
      {/* <Image width={900} src={'https://pic1.zhimg.com/v2-7808ee238bedc7a5978c3a75ccb504b9_1440w.jpg?source=172ae18b'} /> */}
    </AntdModal>
  );
}))
