import React from 'react';
import cls from 'classnames';
import styles from './index.less';

export default React.memo(function Info(
  {
    img, label, value, unit, className = '', valueStyle = {},
    unitStyle = {}, imgStyle = {}
  }) {
  return (
    <div className={cls(styles.info, className)}>
      {img && <img src={img} style={imgStyle} className={styles.infoImg} />}
      <div className={styles.infoContent}>
        <div className={styles.infoLabel}>{label}</div>
        <div className={styles.infoValue} style={valueStyle}>
          {value}
          {value && <span style={unitStyle} className={styles.unit}>{unit}</span>}
        </div>
      </div>
    </div>
  );
});
