import React from 'react';
import './index.less';
import { Form, Button } from 'antd';
import { history, connect } from 'umi';
import loginAvatar from '@/resource/images/screen/loginAvatar.png';
import LoginForm from '@/components/Form/LoginForm';
import * as services from '@/pages/screen/services';
import { setItem } from '@/utils';

const Login = props => {
  const [form] = Form.useForm();

  const goPage = path => {
    console.log(' goPage   path,   ： ', path);
    history.push(path);
  };

  const onFinish = async (values) => {
    console.log('onFinish 提交 : ', values, props);
    const { username, password } = values.values;
    const res = await services.login({ username, password })
    if (res.token) {
      setItem('token', res.token, true);
      history.push('/screen');
    }
  };

  return (
    <div className="loginWrapper">
      <div className="loginFormWrapper">
        <div className="f1"></div>
        <div className="loginForm">
          <div className="loginRow">
            {/* <img src={loginAvatar} className="loginAvatar" /> */}
            <div className="sysystemTitle">欢迎登录平台</div>
          </div>

          <LoginForm
            className="login-form"
            // name="normal_login"
            name="loginForm"
            initialValues={{
              remember: true,
              username: 'admin',
              password: 'afafa',
              username: '',
              password: '',
            }}
            onSubmit={onFinish}
            // onFinish={onFinish}
          >
            <Form.Item className={`btnFormItem`} noStyle>
              <Button type="primary" htmlType="submit" className="actionBtn">
                登录
              </Button>
              {/* <div className="forgetPwdRow">
                <div className="forgetPwd" onClick={() => goPage('forgetPwd')}>
                  忘记密码
                </div>
              </div> */}
            </Form.Item>
          </LoginForm>
        </div>
      </div>
    </div>
  );
};

// export default Login;
export default connect()(Login);
