/*
 * @Description:
 * @Author: yangzhong01
 * @Date: 2021-01-23 14:41:11
 */
import { history } from 'umi';
import { message } from 'antd';

const hasToken = () => {
  return document.cookie.indexOf('token=') > -1
};

export function render(oldRender) {
  // 从cookie里取token
  if (!location.pathname.includes('/login') && !hasToken) {
    message.error('请登录');
    history.push('/login')
    oldRender()
  } else {
    oldRender()
  }
}

export const dva = {
  config: {
    onError(e) {
      e.preventDefault();
      console.error(e.message);
    },
  }
};
