from sqlalchemy import (Column, INTEGER, SMALLINT, FLOAT, DATETIME, NVARCHAR,
                        DECIMAL, TEXT, BOOLEAN)
from sqlalchemy.ext.declarative import declarative_base
from etl.db.db_client import slave_engine, trans_engine

Base = declarative_base(bind=slave_engine)
TransBase = declarative_base(bind=trans_engine)


# 最新监控数据表
class ImReal(Base):
    __tablename__ = 'im_real'

    # 表的结构:
    id = Column(INTEGER, primary_key=True, autoincrement=True)
    immix = Column(NVARCHAR(32), nullable=True)
    line = Column(SMALLINT, nullable=True)
    ua = Column(FLOAT, nullable=True)
    ub = Column(FLOAT, nullable=True)
    uc = Column(FLOAT, nullable=True)
    ia = Column(FLOAT, nullable=True)
    ib = Column(FLOAT, nullable=True)
    ic = Column(FLOAT, nullable=True)
    pa = Column(FLOAT, nullable=True)
    pb = Column(FLOAT, nullable=True)
    pc = Column(FLOAT, nullable=True)
    psum = Column(FLOAT, nullable=True)
    qa = Column(FLOAT, nullable=True)
    qb = Column(FLOAT, nullable=True)
    qc = Column(FLOAT, nullable=True)
    qsum = Column(FLOAT, nullable=True)
    pfa = Column(FLOAT, nullable=True)
    pfb = Column(FLOAT, nullable=True)
    pfc = Column(FLOAT, nullable=True)
    pfsum = Column(FLOAT, nullable=True)
    fr = Column(FLOAT, nullable=True)
    px = Column(FLOAT, nullable=True)
    eq1 = Column(FLOAT, nullable=True)
    eq2 = Column(FLOAT, nullable=True)
    ep = Column(FLOAT, nullable=True)
    tc = Column(FLOAT, nullable=True)
    t = Column(FLOAT, nullable=True)
    s = Column(FLOAT, nullable=True)
    ht = Column(INTEGER, nullable=True)
    ti = Column(INTEGER, nullable=True)
    net = Column(INTEGER, nullable=True)
    tm = Column(DATETIME, nullable=True)
    comments = Column(NVARCHAR(1024), nullable=True)


# 客户表
class CrmCustomer(Base):
    __tablename__ = 'crm_customer'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    sn = Column(NVARCHAR(16), nullable=True)
    name = Column(NVARCHAR(64), nullable=True)
    unit_type = Column(SMALLINT, nullable=True)
    nature = Column(INTEGER, nullable=True)
    size = Column(INTEGER, nullable=True)
    contact_address = Column(NVARCHAR(32), nullable=True)
    address = Column(NVARCHAR(32), nullable=True)
    longitude = Column(DECIMAL(10, 6), nullable=True)
    latitude = Column(DECIMAL(10, 6), nullable=True)
    province = Column(INTEGER, nullable=True)
    city = Column(INTEGER, nullable=True)
    district = Column(INTEGER, nullable=True)
    tax_num = Column(NVARCHAR(32), nullable=True)
    bank_name = Column(NVARCHAR(64), nullable=True)
    bank_account = Column(NVARCHAR(128), nullable=True)
    bank_address = Column(NVARCHAR(128), nullable=True)
    prize_type = Column(SMALLINT, nullable=True)
    p_vol_level = Column(SMALLINT, nullable=True)
    p_capacity = Column(INTEGER, nullable=True)
    p_real_capacity = Column(INTEGER, nullable=True)
    p_our_managed = Column(FLOAT, nullable=True)
    comments = Column(NVARCHAR(1024), nullable=True)
    add_date = Column(DATETIME, nullable=True)
    level = Column(SMALLINT, nullable=True)
    company_id = Column(INTEGER, nullable=True)
    org_id = Column(INTEGER, nullable=True)
    sales_id = Column(INTEGER, nullable=True)
    original_sales_id = Column(INTEGER, nullable=True)
    assign_date = Column(DATETIME, nullable=True)


# 组织表
class OaOrg(Base):
    __tablename__ = 'oa_org'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    name = Column(NVARCHAR(64), nullable=True)
    level = Column(INTEGER, nullable=True)
    superior = Column(INTEGER, nullable=True)
    type = Column(INTEGER, nullable=True)
    distinguish_summer = Column(SMALLINT, nullable=True)
    electricity_type = Column(NVARCHAR(45), nullable=True)
    summer_time = Column(NVARCHAR(45), nullable=True)


class CmContract(Base):
    __tablename__ = 'cm_contract'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    sn = Column(NVARCHAR(64), nullable=True)
    customer_id = Column(INTEGER, nullable=True)
    contract_subject = Column(NVARCHAR(50), nullable=True)
    our_customer_id = Column(INTEGER, nullable=True)
    org_id = Column(INTEGER, nullable=True)
    sign_org_id = Column(INTEGER, nullable=True)
    customer_contact_id = Column(INTEGER, nullable=True)
    support_id = Column(INTEGER, nullable=True)
    sales_id = Column(INTEGER, nullable=True)
    type = Column(SMALLINT, nullable=True)
    sub_type = Column(SMALLINT, nullable=True)
    price = Column(DECIMAL(18, 2), nullable=True)
    payed_price = Column(DECIMAL(18, 2), nullable=True)
    start_date = Column(DATETIME, nullable=True)
    expiration_date = Column(DATETIME, nullable=True)
    signed_date = Column(DATETIME, nullable=True)
    close_date = Column(DATETIME, nullable=True)
    child_id = Column(INTEGER, nullable=True)
    comments = Column(NVARCHAR(1024), nullable=True)
    billing_period = Column(INTEGER, nullable=True)
    liquidated_damages = Column(DECIMAL(5, 2), nullable=True)
    offer_id = Column(INTEGER, nullable=True)
    offer_sn = Column(NVARCHAR(15), nullable=True)


class CmPayPlan(Base):
    __tablename__ = 'cm_pay_plan'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    contract_id = Column(INTEGER, nullable=True)
    create_time = Column(DATETIME, nullable=True)
    pay_date = Column(DATETIME, nullable=True)
    pay_amount = Column(DECIMAL(18, 2), nullable=True)
    receipt_status = Column(SMALLINT, nullable=True)
    receipt_amount = Column(DECIMAL(18, 2), nullable=True)
    receipt_date = Column(DATETIME, nullable=True)
    billing_sn = Column(NVARCHAR(32), nullable=True)
    billing_date = Column(DATETIME, nullable=True)
    billing_sign_date = Column(DATETIME, nullable=True)
    comments = Column(NVARCHAR(1024), nullable=True)
    notification_date = Column(DATETIME, nullable=True)
    notification_comments = Column(NVARCHAR(1024), nullable=True)
    dunning_date = Column(DATETIME, nullable=True)
    dunning_comments = Column(NVARCHAR(1024), nullable=True)
    receipt_billing_date = Column(DATETIME, nullable=True)
    billing_signed_man = Column(NVARCHAR(10), nullable=True)
    legal_date = Column(DATETIME, nullable=True)
    legal_comments = Column(NVARCHAR(1024), nullable=True)
    litigation_date = Column(NVARCHAR(256), nullable=True)
    litigation_comments = Column(NVARCHAR(1024), nullable=True)
    jd_comments = Column(NVARCHAR(256), nullable=True)


class CmPayPlanDetail(Base):
    __tablename__ = 'cm_pay_plan_detail'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    cm_pay_plan_id = Column(INTEGER, nullable=True)
    receipt_amount = Column(DECIMAL(14, 2), nullable=True)
    receipt_date = Column(NVARCHAR(256), nullable=True)
    comments = Column(NVARCHAR(256), nullable=True)


class CrmSource(Base):
    __tablename__ = 'crm_source'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    customer_id = Column(INTEGER, nullable=True)
    sn = Column(NVARCHAR(16), nullable=True)
    meter_sn = Column(NVARCHAR(16), nullable=True)
    line_name = Column(NVARCHAR(32), nullable=True)
    price_type = Column(SMALLINT, nullable=True)
    voltage_level = Column(SMALLINT, nullable=True)
    override = Column(INTEGER, nullable=True)
    power_factor = Column(DECIMAL(3, 2), nullable=True)
    basic_price_type = Column(INTEGER, nullable=True)
    comments = Column(NVARCHAR(256), nullable=True)


class CrmTransformer(Base):
    __tablename__ = 'crm_transformer'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    source_id = Column(INTEGER, nullable=True)
    no = Column(SMALLINT, nullable=True)
    capacity = Column(INTEGER, nullable=True)
    real_capacity = Column(INTEGER, nullable=True)
    comments = Column(NVARCHAR(256), nullable=True)


class CrmVisit(Base):
    __tablename__ = 'crm_visit'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    customer_id = Column(INTEGER, nullable=True)
    contact_id = Column(INTEGER, nullable=True)
    sales_id = Column(INTEGER, nullable=True)
    longitude = Column(DECIMAL(10, 6), nullable=True)
    latitude = Column(DECIMAL(10, 6), nullable=True)
    distance = Column(INTEGER, nullable=True)
    relationship = Column(SMALLINT, nullable=True)
    report = Column(NVARCHAR(256), nullable=True)
    comments = Column(SMALLINT, nullable=True)
    time = Column(DATETIME, nullable=True)


class CmLegal(Base):
    __tablename__ = 'cm_legal'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    contract_id = Column(INTEGER, nullable=True)
    pay_plan_id = Column(INTEGER, nullable=True)
    type = Column(SMALLINT, nullable=True)
    start_date = Column(DATETIME, nullable=True)
    end_date = Column(DATETIME, nullable=True)
    status = Column(SMALLINT, nullable=True)
    express_no = Column(NVARCHAR(32), nullable=True)
    signee = Column(NVARCHAR(32), nullable=True)
    comments = Column(NVARCHAR(1024), nullable=True)


class CrmContact(Base):
    __tablename__ = 'crm_contact'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    customer_id = Column(INTEGER, nullable=True)
    name = Column(NVARCHAR(16), nullable=True)
    tel = Column(NVARCHAR(32), nullable=True)
    mobile = Column(NVARCHAR(32), nullable=True)
    position = Column(NVARCHAR(16), nullable=True)
    email = Column(NVARCHAR(32), nullable=True)
    qq = Column(NVARCHAR(16), nullable=True)
    wx = Column(NVARCHAR(32), nullable=True)
    duty_type = Column(SMALLINT, nullable=True)
    is_dun = Column(SMALLINT, nullable=True)
    comments = Column(NVARCHAR(256), nullable=True)
    percentage = Column(DECIMAL(4, 3), nullable=True)


class IcInstockDetail(Base):
    __tablename__ = 'ic_instock_detail'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    instock_id = Column(INTEGER, nullable=True)
    material_id = Column(INTEGER, nullable=True)
    storage = Column(NVARCHAR(32), nullable=True)
    number = Column(INTEGER, nullable=True)
    price = Column(DECIMAL(12, 2), nullable=True)
    amount = Column(DECIMAL(12, 2), nullable=True)


class IcMaterial(Base):
    __tablename__ = 'ic_material'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    type_id = Column(INTEGER, nullable=True)
    factory_id = Column(INTEGER, nullable=True)
    name = Column(NVARCHAR(64), nullable=True)
    model = Column(NVARCHAR(64), nullable=True)
    unit = Column(NVARCHAR(16), nullable=True)
    in_refer_price = Column(DECIMAL(12, 2), nullable=True)
    out_refer_price = Column(DECIMAL(12, 2), nullable=True)
    comments = Column(NVARCHAR(16), nullable=True)
    is_delete = Column(SMALLINT, nullable=True)


class IcMaterialTest(Base):
    __tablename__ = 'ic_material_test'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    type_id = Column(INTEGER, nullable=True)
    factory_id = Column(INTEGER, nullable=True)
    name = Column(NVARCHAR(64), nullable=True)
    model = Column(NVARCHAR(64), nullable=True)
    unit = Column(NVARCHAR(16), nullable=True)
    in_refer_price = Column(DECIMAL(12, 2), nullable=True)
    out_refer_price = Column(DECIMAL(12, 2), nullable=True)
    comments = Column(NVARCHAR(128), nullable=True)


class IcOutstockDetail(Base):
    __tablename__ = 'ic_outstock_detail'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    outstock_id = Column(INTEGER, nullable=True)
    material_id = Column(INTEGER, nullable=True)
    storage = Column(INTEGER, nullable=True)
    number = Column(INTEGER, nullable=True)
    in_price = Column(DECIMAL(12, 2), nullable=True)
    out_price = Column(DECIMAL(12, 2), nullable=True)
    amount = Column(DECIMAL(12, 2), nullable=True)


class IcOffer(Base):
    __tablename__ = 'ic_offer'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    oa_org_id = Column(INTEGER, nullable=True)
    oa_user_id = Column(INTEGER, nullable=True)
    our_address = Column(NVARCHAR(64), nullable=True)
    our_phone = Column(NVARCHAR(11), nullable=True)
    our_email = Column(NVARCHAR(50), nullable=True)
    review_date = Column(DATETIME, nullable=True)
    nuclear_price_date = Column(DATETIME, nullable=True)
    crm_customer_id = Column(INTEGER, nullable=True)
    customer_address = Column(NVARCHAR(64), nullable=True)
    customer_contact = Column(NVARCHAR(10), nullable=True)
    customer_phone = Column(NVARCHAR(11), nullable=True)
    customer_email = Column(NVARCHAR(50), nullable=True)
    managed = Column(SMALLINT, nullable=True)
    project_type = Column(INTEGER, nullable=True)
    no = Column(NVARCHAR(64), nullable=True)
    construction_date = Column(DATETIME, nullable=True)
    apply_date = Column(DATETIME, nullable=True)
    approve_date = Column(DATETIME, nullable=True)
    status = Column(INTEGER, nullable=True)
    reviewer_id = Column(INTEGER, nullable=True)
    nuclear_price_id = Column(INTEGER, nullable=True)
    approver_id = Column(INTEGER, nullable=True)
    comment = Column(NVARCHAR(128), nullable=True)
    sales_comment = Column(NVARCHAR(128), nullable=True)
    review_comment = Column(NVARCHAR(128), nullable=True)
    marketing_comment = Column(NVARCHAR(128), nullable=True)
    approve_comment = Column(NVARCHAR(128), nullable=True)
    price = Column(DECIMAL(12, 2), nullable=True)


class IcOfferDetail(Base):
    __tablename__ = 'ic_offer_detail'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    no = Column(INTEGER, nullable=True)
    ic_material_id = Column(INTEGER, nullable=True)
    ic_offer_id = Column(INTEGER, nullable=True)
    cost_price = Column(DECIMAL(12, 2), nullable=True)
    sell_price = Column(DECIMAL(12, 2), nullable=True)
    number = Column(INTEGER, nullable=True)
    comment = Column(NVARCHAR(128), nullable=True)


class IcOutstock(Base):
    __tablename__ = 'ic_outstock'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    no = Column(NVARCHAR(32), nullable=True)
    type = Column(INTEGER, nullable=True)
    storehouse = Column(INTEGER, nullable=True)
    project_id = Column(INTEGER, nullable=True)
    users = Column(NVARCHAR(32), nullable=True)
    agent_id = Column(INTEGER, nullable=True)
    out_date = Column(DATETIME, nullable=True)
    status = Column(INTEGER, nullable=True)
    comments = Column(NVARCHAR(128), nullable=True)


class IcStock(Base):
    __tablename__ = 'ic_stock'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    material_id = Column(INTEGER, nullable=True)
    location = Column(INTEGER, nullable=True)
    storage = Column(NVARCHAR(32), nullable=True)
    stock = Column(INTEGER, nullable=True)
    real_price = Column(DECIMAL(12, 2), nullable=True)


class DutyList(Base):
    __tablename__ = 'duty_list'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    start_date = Column(DATETIME, nullable=True)
    end_date = Column(DATETIME, nullable=True)
    customer_id = Column(NVARCHAR(11), nullable=True)
    personnel_id = Column(INTEGER, nullable=True)
    work_mode = Column(INTEGER, nullable=True)
    job = Column(INTEGER, nullable=True)


class EtList(Base):
    __tablename__ = 'et_list'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    project_id = Column(INTEGER, nullable=True)
    experiment_type = Column(INTEGER, nullable=True)
    vol_level = Column(INTEGER, nullable=True)
    report_type = Column(INTEGER, nullable=True)
    content = Column(NVARCHAR(1024), nullable=True)
    add_date = Column(DATETIME, nullable=True)


class IcApply(Base):
    __tablename__ = 'ic_apply'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    depart = Column(INTEGER, nullable=True)
    number = Column(INTEGER, nullable=True)
    status = Column(INTEGER, nullable=True)
    year_month = Column(NVARCHAR(7), nullable=True)
    comments = Column(NVARCHAR(128), nullable=True)


class IcApplyDetail(Base):
    __tablename__ = 'ic_apply_detail'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    apply_id = Column(INTEGER, nullable=True)
    material_id = Column(INTEGER, nullable=True)
    number = Column(INTEGER, nullable=True)


class IcReport(Base):
    __tablename__ = 'ic_report'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    material_id = Column(INTEGER, nullable=True)
    year_month = Column(NVARCHAR(7), nullable=True)
    last_number = Column(INTEGER, nullable=True)
    in_number = Column(INTEGER, nullable=True)
    out_number = Column(INTEGER, nullable=True)
    stock = Column(INTEGER, nullable=True)


class ImCustomer(Base):
    __tablename__ = 'im_customer'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    customer_id = Column(INTEGER, nullable=True)
    user_id = Column(INTEGER, nullable=True)
    agent_id = Column(INTEGER, nullable=True)
    server_no = Column(INTEGER, nullable=True)
    start_date = Column(DATETIME, nullable=True)
    end_date = Column(DATETIME, nullable=True)
    bill_date = Column(SMALLINT, nullable=True)


class ImAlertList(Base):
    __tablename__ = 'im_alert_list'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    device_id = Column(INTEGER, nullable=True)
    type = Column(INTEGER, nullable=True)
    level = Column(INTEGER, nullable=True)
    value = Column(FLOAT, nullable=True)
    status = Column(INTEGER, nullable=True)
    start_time = Column(DATETIME, nullable=True)
    last_time = Column(DATETIME, nullable=True)
    end_time = Column(DATETIME, nullable=True)
    times = Column(INTEGER, nullable=True)


class ImAlertValue(Base):
    __tablename__ = 'im_alert_value'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    device_id = Column(INTEGER, nullable=True)
    uhigh_red = Column(FLOAT, nullable=True)
    uhigh_yellow = Column(FLOAT, nullable=True)
    uhigh_send = Column(SMALLINT, nullable=True)
    ulow_red = Column(FLOAT, nullable=True)
    ulow_yellow = Column(FLOAT, nullable=True)
    ulow_send = Column(SMALLINT, nullable=True)
    i_red = Column(FLOAT, nullable=True)
    i_yellow = Column(FLOAT, nullable=True)
    i_send = Column(SMALLINT, nullable=True)
    pf_red = Column(FLOAT, nullable=True)
    pf_send = Column(SMALLINT, nullable=True)
    md_red = Column(FLOAT, nullable=True)
    md_send = Column(SMALLINT, nullable=True)
    ep_red = Column(FLOAT, nullable=True)
    ep_yellow = Column(FLOAT, nullable=True)
    ep_send = Column(SMALLINT, nullable=True)
    t_send = Column(SMALLINT, nullable=True)
    s_send = Column(SMALLINT, nullable=True)
    outage_send = Column(SMALLINT, nullable=True)
    offline_send = Column(SMALLINT, nullable=True)
    sendto = Column(NVARCHAR(35), nullable=True)


class ImDevice(Base):
    __tablename__ = 'im_device'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    im_customer_id = Column(INTEGER, nullable=True)
    sn = Column(NVARCHAR(32), nullable=True)
    name = Column(NVARCHAR(64), nullable=True)
    type = Column(INTEGER, nullable=True)
    status = Column(INTEGER, nullable=True)
    online_time = Column(DATETIME, nullable=True)
    sim_no = Column(NVARCHAR(13), nullable=True)
    sim_type = Column(INTEGER, nullable=True)
    frequency = Column(SMALLINT, nullable=True)
    source_id = Column(INTEGER, nullable=True)
    transformer_id = Column(INTEGER, nullable=True)
    no = Column(INTEGER, nullable=True)
    v_c = Column(INTEGER, nullable=True)
    i_c = Column(INTEGER, nullable=True)
    x = Column(INTEGER, nullable=True)
    y = Column(INTEGER, nullable=True)
    non_summer_price = Column(INTEGER, nullable=True)
    summer_price = Column(INTEGER, nullable=True)
    voltage_line = Column(NVARCHAR(50), nullable=True)


class OaRole(Base):
    __tablename__ = 'oa_role'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    name = Column(NVARCHAR(45), nullable=True)
    type = Column(INTEGER, nullable=True)


class ImLoad(Base):
    __tablename__ = 'im_load'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    im_device_id = Column(INTEGER, nullable=True)
    max_ep = Column(DECIMAL(10, 2), nullable=True)
    max_load_rate = Column(DECIMAL(10, 2), nullable=True)
    date = Column(DATETIME, nullable=True)


class ImPower(Base):
    __tablename__ = 'im_power'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    im_device_id = Column(INTEGER, nullable=True)
    date = Column(DATETIME, nullable=True)
    power_efficiency = Column(DECIMAL(4, 2), nullable=True)
    power_generation = Column(DECIMAL(10, 2), nullable=True)
    weather = Column(INTEGER, nullable=True)


class IoCustomer(Base):
    __tablename__ = 'io_customer'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    customer_id = Column(INTEGER, nullable=True)
    contact_id = Column(INTEGER, nullable=True)
    contract_id = Column(INTEGER, nullable=True)
    inspector_id = Column(INTEGER, nullable=True)
    start_date = Column(DATETIME, nullable=True)
    end_date = Column(DATETIME, nullable=True)
    last_et_date = Column(DATETIME, nullable=True)
    et_date = Column(DATETIME, nullable=True)
    et_charge = Column(SMALLINT, nullable=True)
    customize_date = Column(DATETIME, nullable=True)
    times = Column(SMALLINT, nullable=True)
    md_report = Column(SMALLINT, nullable=True)
    check_date1 = Column(DATETIME, nullable=True)
    check_date2 = Column(DATETIME, nullable=True)
    check_date3 = Column(DATETIME, nullable=True)
    check_date4 = Column(DATETIME, nullable=True)
    check_date5 = Column(DATETIME, nullable=True)
    check_date6 = Column(DATETIME, nullable=True)
    comments = Column(NVARCHAR(256), nullable=True)
    stopped = Column(SMALLINT, nullable=True)
    config_num = Column(INTEGER, nullable=True)
    shift_time = Column(NVARCHAR(32), nullable=True)


class IoBilling(Base):
    __tablename__ = 'io_billing'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    source_id = Column(INTEGER, nullable=True)
    year_month = Column(NVARCHAR(7), nullable=True)
    peak_volume = Column(INTEGER, nullable=True)
    peak_volume2 = Column(INTEGER, nullable=True)
    tip_volume = Column(INTEGER, nullable=True)
    tip_volume2 = Column(INTEGER, nullable=True)
    usual_volume = Column(INTEGER, nullable=True)
    usual_volume2 = Column(INTEGER, nullable=True)
    valley_volume = Column(INTEGER, nullable=True)
    valley_volume2 = Column(INTEGER, nullable=True)
    other_volume = Column(INTEGER, nullable=True)
    peak_price = Column(DECIMAL(6, 5), nullable=True)
    peak_price2 = Column(DECIMAL(6, 5), nullable=True)
    tip_price = Column(DECIMAL(6, 5), nullable=True)
    tip_price2 = Column(DECIMAL(6, 5), nullable=True)
    usual_price = Column(DECIMAL(6, 5), nullable=True)
    usual_price2 = Column(DECIMAL(6, 5), nullable=True)
    valley_price = Column(DECIMAL(6, 5), nullable=True)
    valley_price2 = Column(DECIMAL(6, 5), nullable=True)
    other_price = Column(DECIMAL(6, 5), nullable=True)
    levy_fee = Column(DECIMAL(10, 2), nullable=True)
    power_factor = Column(DECIMAL(3, 2), nullable=True)
    power_factor_real = Column(DECIMAL(3, 2), nullable=True)
    power_factor_adjust = Column(DECIMAL(4, 2), nullable=True)
    report_md = Column(DECIMAL(10, 2), nullable=True)
    max_md = Column(INTEGER, nullable=True)
    basic_price = Column(DECIMAL(8, 5), nullable=True)
    capacity = Column(INTEGER, nullable=True)
    idle_volume = Column(INTEGER, nullable=True)
    amount = Column(DECIMAL(12, 2), nullable=True)
    amount_adjust = Column(DECIMAL(10, 2), nullable=True)


class IoDefect(Base):
    __tablename__ = 'io_defect'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    io_customer_id = Column(INTEGER, nullable=True)
    input_date = Column(DATETIME, nullable=True)
    close_date = Column(DATETIME, nullable=True)
    level = Column(INTEGER, nullable=True)
    position = Column(INTEGER, nullable=True)
    desc = Column(NVARCHAR(512), nullable=True)
    result = Column(NVARCHAR(256), nullable=True)
    advise = Column(NVARCHAR(256), nullable=True)
    business = Column(NVARCHAR(256), nullable=True)
    status = Column(INTEGER, nullable=True)
    contract_id = Column(INTEGER, nullable=True)
    return_amount = Column(INTEGER, nullable=True)
    img_src = Column(NVARCHAR(128), nullable=True)


class OaRight(Base):
    __tablename__ = 'oa_right'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    oa_role_id = Column(INTEGER, nullable=True)
    module = Column(INTEGER, nullable=True)
    page = Column(INTEGER, nullable=True)
    data_range = Column(INTEGER, nullable=True)
    visit = Column(SMALLINT, nullable=True)
    add = Column(SMALLINT, nullable=True)
    delete = Column(SMALLINT, nullable=True)
    check = Column(SMALLINT, nullable=True)
    review = Column(SMALLINT, nullable=True)
    edit = Column(SMALLINT, nullable=True)


class IoInspect(Base):
    __tablename__ = 'io_inspect'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    customer_id = Column(INTEGER, nullable=True)
    year_month = Column(NVARCHAR(11), nullable=True)
    date = Column(DATETIME, nullable=True)
    temp = Column(DECIMAL(4, 1), nullable=True)
    humi = Column(DECIMAL(4, 1), nullable=True)
    weather = Column(INTEGER, nullable=True)
    house1 = Column(INTEGER, nullable=True)
    house2 = Column(INTEGER, nullable=True)
    house3 = Column(INTEGER, nullable=True)
    house4 = Column(INTEGER, nullable=True)
    house5 = Column(INTEGER, nullable=True)
    house6 = Column(INTEGER, nullable=True)
    facility1 = Column(INTEGER, nullable=True)
    facility2 = Column(INTEGER, nullable=True)
    facility3 = Column(INTEGER, nullable=True)
    facility4 = Column(INTEGER, nullable=True)
    facility5 = Column(INTEGER, nullable=True)
    facility6 = Column(INTEGER, nullable=True)
    inspector = Column(NVARCHAR(45), nullable=True)
    status = Column(INTEGER, nullable=True)
    comments = Column(NVARCHAR(256), nullable=True)


class OaLog(Base):
    __tablename__ = 'oa_log'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    user_id = Column(INTEGER, nullable=True)
    action = Column(INTEGER, nullable=True)
    info = Column(NVARCHAR(256), nullable=True)
    time = Column(DATETIME, nullable=True)
    module = Column(INTEGER, nullable=True)
    page = Column(INTEGER, nullable=True)
    data_id = Column(INTEGER, nullable=True)
    original_data = Column(NVARCHAR(45), nullable=True)
    modified_data = Column(NVARCHAR(45), nullable=True)
    save_data = Column(NVARCHAR(45), nullable=True)


class IoPrice(Base):
    __tablename__ = 'io_price'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    oa_org_id = Column(INTEGER, nullable=True)
    name = Column(NVARCHAR(45), nullable=True)
    tip_price = Column(DECIMAL(7, 6), nullable=True)
    peak_price = Column(DECIMAL(7, 6), nullable=True)
    usual_price = Column(DECIMAL(7, 6), nullable=True)
    valley_price = Column(DECIMAL(7, 6), nullable=True)
    other_price = Column(DECIMAL(7, 6), nullable=True)
    basic_price = Column(DECIMAL(8, 5), nullable=True)
    voltage_level = Column(INTEGER, nullable=True)
    price_type = Column(INTEGER, nullable=True)
    is_summer = Column(SMALLINT, nullable=True)


class IoInspectIn(Base):
    __tablename__ = 'io_inspect_in'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    inspect_id = Column(INTEGER, nullable=True)
    source_id = Column(INTEGER, nullable=True)
    active_volume = Column(DECIMAL(10, 2), nullable=True)
    peak_volume = Column(DECIMAL(10, 2), nullable=True)
    usual1_volume = Column(DECIMAL(10, 2), nullable=True)
    usual2_volume = Column(DECIMAL(10, 2), nullable=True)
    valley_volume = Column(DECIMAL(10, 2), nullable=True)
    idle1_volume = Column(DECIMAL(9, 2), nullable=True)
    idle2_volume = Column(DECIMAL(9, 2), nullable=True)
    power_factor_real = Column(DECIMAL(3, 2), nullable=True)
    peak_md = Column(DECIMAL(6, 4), nullable=True)
    usual1_md = Column(DECIMAL(6, 4), nullable=True)
    usual2_md = Column(DECIMAL(6, 4), nullable=True)
    valley_md = Column(DECIMAL(6, 4), nullable=True)
    max_md = Column(DECIMAL(10, 2), nullable=True)
    v_ab = Column(NVARCHAR(6), nullable=True)
    v_bc = Column(NVARCHAR(6), nullable=True)
    v_ca = Column(NVARCHAR(6), nullable=True)
    pd_a = Column(INTEGER, nullable=True)
    pd_b = Column(INTEGER, nullable=True)
    pd_c = Column(INTEGER, nullable=True)


class MmTarget(Base):
    __tablename__ = 'mm_target'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    company_id = Column(INTEGER, nullable=True)
    org_id = Column(INTEGER, nullable=True)
    sales_id = Column(INTEGER, nullable=True)
    year = Column(INTEGER, nullable=True)
    target = Column(INTEGER, nullable=True)


class IoInspectOut(Base):
    __tablename__ = 'io_inspect_out'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    inspect_id = Column(INTEGER, nullable=True)
    source_id = Column(INTEGER, nullable=True)
    transformer_id = Column(INTEGER, nullable=True)
    o_ia = Column(NVARCHAR(6), nullable=True)
    o_ib = Column(NVARCHAR(6), nullable=True)
    o_ic = Column(NVARCHAR(6), nullable=True)
    o_pda = Column(INTEGER, nullable=True)
    o_pdb = Column(INTEGER, nullable=True)
    o_pdc = Column(INTEGER, nullable=True)
    t_voice = Column(INTEGER, nullable=True)
    t_fan = Column(INTEGER, nullable=True)
    t_oil = Column(INTEGER, nullable=True)
    t_dry = Column(INTEGER, nullable=True)
    t_exception = Column(INTEGER, nullable=True)
    t_temp = Column(NVARCHAR(24), nullable=True)
    s_vab = Column(INTEGER, nullable=True)
    s_vbc = Column(INTEGER, nullable=True)
    s_vca = Column(INTEGER, nullable=True)
    s_ia = Column(INTEGER, nullable=True)
    s_ib = Column(INTEGER, nullable=True)
    s_ic = Column(INTEGER, nullable=True)
    ec_status = Column(INTEGER, nullable=True)


class IoMd(Base):
    __tablename__ = 'io_md'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    source_id = Column(INTEGER, nullable=True)
    year_month = Column(NVARCHAR(7), nullable=True)
    capacity = Column(INTEGER, nullable=True)
    capacity_real = Column(INTEGER, nullable=True)
    report_type = Column(INTEGER, nullable=True)
    report_md = Column(NVARCHAR(10), nullable=True)
    max_md = Column(INTEGER, nullable=True)
    inspect_md = Column(INTEGER, nullable=True)
    last_report_md = Column(DECIMAL(10, 2), nullable=True)
    date = Column(DATETIME, nullable=True)
    status = Column(INTEGER, nullable=True)
    comments = Column(NVARCHAR(256), nullable=True)
    reason = Column(NVARCHAR(256), nullable=True)


class PmFollow(Base):
    __tablename__ = 'pm_follow'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    pm_item_id = Column(INTEGER, nullable=True)
    date = Column(DATETIME, nullable=True)
    content = Column(NVARCHAR(512), nullable=True)


class OaUser(Base):
    __tablename__ = 'oa_user'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    name = Column(NVARCHAR(20), nullable=True)
    password = Column(NVARCHAR(32), nullable=True)
    nick = Column(NVARCHAR(32), nullable=True)
    role = Column(INTEGER, nullable=True)
    role_id = Column(NVARCHAR(64), nullable=True)
    contact_id = Column(INTEGER, nullable=True)
    weixin_id = Column(NVARCHAR(32), nullable=True)
    company_id = Column(INTEGER, nullable=True)
    org_id = Column(INTEGER, nullable=True)
    target = Column(INTEGER, nullable=True)
    login_time = Column(DATETIME, nullable=True)
    login_ip = Column(NVARCHAR(15), nullable=True)


class PersonnelList(Base):
    __tablename__ = 'personnel_list'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    hire_date = Column(DATETIME, nullable=True)
    departure_date = Column(DATETIME, nullable=True)
    name = Column(NVARCHAR(10), nullable=True)
    born_date = Column(DATETIME, nullable=True)
    sex = Column(SMALLINT, nullable=True)
    mobile = Column(NVARCHAR(11), nullable=True)
    status = Column(INTEGER, nullable=True)
    part_time_company = Column(NVARCHAR(45), nullable=True)
    willing = Column(SMALLINT, nullable=True)
    address = Column(NVARCHAR(64), nullable=True)
    longitude = Column(DECIMAL(10, 6), nullable=True)
    latitude = Column(DECIMAL(10, 6), nullable=True)
    comment = Column(NVARCHAR(128), nullable=True)
    add_date = Column(DATETIME, nullable=True)


class PmItem(Base):
    __tablename__ = 'pm_item'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    crm_customer_id = Column(INTEGER, nullable=True)
    cm_contract_id = Column(INTEGER, nullable=True)
    project_mange = Column(INTEGER, nullable=True)
    process_analysis = Column(INTEGER, nullable=True)
    progress1_date = Column(DATETIME, nullable=True)
    progress2_date = Column(DATETIME, nullable=True)
    progress3_date = Column(DATETIME, nullable=True)
    progress4_date = Column(DATETIME, nullable=True)
    progress5_date = Column(DATETIME, nullable=True)
    progress6_date = Column(DATETIME, nullable=True)
    progress7_date = Column(DATETIME, nullable=True)
    progress8_date = Column(DATETIME, nullable=True)
    progress9_date = Column(DATETIME, nullable=True)
    real_progress1_date = Column(DATETIME, nullable=True)
    real_progress2_date = Column(DATETIME, nullable=True)
    real_progress3_date = Column(DATETIME, nullable=True)
    real_progress4_date = Column(DATETIME, nullable=True)
    real_progress5_date = Column(DATETIME, nullable=True)
    real_progress6_date = Column(DATETIME, nullable=True)
    real_progress7_date = Column(DATETIME, nullable=True)
    real_progress8_date = Column(DATETIME, nullable=True)
    real_progress9_date = Column(DATETIME, nullable=True)
    bidding = Column(SMALLINT, nullable=True)
    win_bidding_date = Column(DATETIME, nullable=True)
    start_date = Column(DATETIME, nullable=True)
    suspend_date = Column(DATETIME, nullable=True)
    termination_date = Column(DATETIME, nullable=True)
    end_date = Column(DATETIME, nullable=True)
    status = Column(INTEGER, nullable=True)
    comments = Column(NVARCHAR(512), nullable=True)
    archives_no = Column(NVARCHAR(9), nullable=True)
    keep_archives = Column(SMALLINT, nullable=True)
    archives_comments = Column(NVARCHAR(512), nullable=True)


class PmImplement(Base):
    __tablename__ = 'pm_implement'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    pm_project_id = Column(INTEGER, nullable=True)
    content = Column(NVARCHAR(1024), nullable=True)
    start_time = Column(DATETIME, nullable=True)
    end_time = Column(DATETIME, nullable=True)
    customer_on_site = Column(SMALLINT, nullable=True)
    salesman_on_site = Column(SMALLINT, nullable=True)
    start_longitude = Column(DECIMAL(10, 6), nullable=True)
    start_latitude = Column(DECIMAL(10, 6), nullable=True)
    end_longitude = Column(DECIMAL(10, 6), nullable=True)
    end_latitude = Column(DECIMAL(10, 6), nullable=True)
    participants_id = Column(INTEGER, nullable=True)
    wage = Column(DECIMAL(10, 2), nullable=True)
    comments = Column(NVARCHAR(1024), nullable=True)


class PmSupport(Base):
    __tablename__ = 'pm_support'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    sales_id = Column(INTEGER, nullable=True)
    customer_name = Column(NVARCHAR(50), nullable=True)
    customer_address = Column(NVARCHAR(128), nullable=True)
    contact_name = Column(NVARCHAR(10), nullable=True)
    contact_mobile = Column(NVARCHAR(11), nullable=True)
    type = Column(INTEGER, nullable=True)
    descriptions = Column(NVARCHAR(256), nullable=True)
    suppose_date = Column(DATETIME, nullable=True)
    dispatch_org_id = Column(INTEGER, nullable=True)
    supporter_id = Column(INTEGER, nullable=True)
    process = Column(NVARCHAR(256), nullable=True)
    apply_time = Column(DATETIME, nullable=True)
    response_time = Column(DATETIME, nullable=True)
    support_time = Column(DATETIME, nullable=True)
    satisfaction = Column(INTEGER, nullable=True)
    comment = Column(NVARCHAR(128), nullable=True)
    status = Column(INTEGER, nullable=True)
    reject_reason = Column(NVARCHAR(128), nullable=True)
    comment_time = Column(DATETIME, nullable=True)
    sign_contract_id = Column(INTEGER, nullable=True)
    close_reason = Column(NVARCHAR(256), nullable=True)
    close_time = Column(DATETIME, nullable=True)
    estimated_amt = Column(INTEGER, nullable=True)
    comments = Column(NVARCHAR(1024), nullable=True)


class PmProject(Base):
    __tablename__ = 'pm_project'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    project_sn = Column(INTEGER, nullable=True)
    crm_customer_id = Column(INTEGER, nullable=True)
    application_time = Column(DATETIME, nullable=True)
    crm_contact_id = Column(INTEGER, nullable=True)
    content = Column(NVARCHAR(1024), nullable=True)
    end_time = Column(DATETIME, nullable=True)
    start_time = Column(DATETIME, nullable=True)
    information = Column(NVARCHAR(1024), nullable=True)
    cm_contract_id = Column(INTEGER, nullable=True)
    type = Column(SMALLINT, nullable=True)
    status = Column(SMALLINT, nullable=True)
    send_workers_id = Column(INTEGER, nullable=True)
    dispatch_time = Column(DATETIME, nullable=True)
    implement_start_time = Column(DATETIME, nullable=True)
    implement_end_time = Column(DATETIME, nullable=True)
    project_message = Column(NVARCHAR(1024), nullable=True)
    construction_id = Column(INTEGER, nullable=True)
    estimated_man_hour = Column(INTEGER, nullable=True)
    accept_time = Column(DATETIME, nullable=True)
    tell_date = Column(SMALLINT, nullable=True)
    power_failure = Column(SMALLINT, nullable=True)
    work_ticket = Column(SMALLINT, nullable=True)
    application_id = Column(INTEGER, nullable=True)
    audit_time = Column(DATETIME, nullable=True)
    return_time = Column(DATETIME, nullable=True)


class PmQuality(Base):
    __tablename__ = 'pm_quality'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    project_id = Column(INTEGER, nullable=True)
    customer_service_id = Column(INTEGER, nullable=True)
    quality = Column(SMALLINT, nullable=True)
    attitude = Column(SMALLINT, nullable=True)
    appearance = Column(SMALLINT, nullable=True)
    opinion = Column(NVARCHAR(1024), nullable=True)


class PointsAssign(Base):
    __tablename__ = 'points_assign'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    crm_contact_id = Column(INTEGER, nullable=True)
    points_user_id = Column(INTEGER, nullable=True)
    cm_contract_id = Column(INTEGER, nullable=True)
    percentage = Column(DECIMAL(4, 3), nullable=True)
    points_ratio = Column(DECIMAL(4, 3), nullable=True)
    status = Column(INTEGER, nullable=True)
    comments = Column(NVARCHAR(1024), nullable=True)


class PmSupportFollow(Base):
    __tablename__ = 'pm_support_follow'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    pm_support_id = Column(INTEGER, nullable=True)
    content = Column(NVARCHAR(256), nullable=True)
    follow_time = Column(DATETIME, nullable=True)


class PointsGoods(Base):
    __tablename__ = 'points_goods'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    name = Column(NVARCHAR(45), nullable=True)
    img_src = Column(NVARCHAR(60), nullable=True)
    desc = Column(TEXT, nullable=True)
    points = Column(INTEGER, nullable=True)
    stock = Column(INTEGER, nullable=True)
    status = Column(SMALLINT, nullable=True)


class PointsReceipt(Base):
    __tablename__ = 'points_receipt'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    name = Column(NVARCHAR(10), nullable=True)
    crm_contact_id = Column(INTEGER, nullable=True)
    points_user_id = Column(INTEGER, nullable=True)
    mobile = Column(NVARCHAR(20), nullable=True)
    district = Column(NVARCHAR(6), nullable=True)
    address = Column(NVARCHAR(32), nullable=True)
    default = Column(SMALLINT, nullable=True)


class PointsOrder(Base):
    __tablename__ = 'points_order'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    goods_id = Column(INTEGER, nullable=True)
    crm_contact_id = Column(INTEGER, nullable=True)
    points_user_id = Column(INTEGER, nullable=True)
    address = Column(NVARCHAR(128), nullable=True)
    points = Column(INTEGER, nullable=True)
    num = Column(INTEGER, nullable=True)
    express_company = Column(NVARCHAR(10), nullable=True)
    express_num = Column(NVARCHAR(15), nullable=True)
    status = Column(INTEGER, nullable=True)
    add_time = Column(DATETIME, nullable=True)
    approve_time = Column(DATETIME, nullable=True)
    deliver_time = Column(DATETIME, nullable=True)
    cancel_comment = Column(NVARCHAR(45), nullable=True)
    reject_comment = Column(NVARCHAR(45), nullable=True)


class PointsTotal(Base):
    __tablename__ = 'points_total'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    crm_contact_id = Column(INTEGER, nullable=True)
    points_user_id = Column(INTEGER, nullable=True)
    token = Column(NVARCHAR(32), nullable=True)
    points = Column(INTEGER, nullable=True)
    points_expired = Column(INTEGER, nullable=True)
    points_used = Column(INTEGER, nullable=True)
    points_usable = Column(INTEGER, nullable=True)
    continuous_days = Column(INTEGER, nullable=True)
    login_time = Column(DATETIME, nullable=True)


class PointsRecord(Base):
    __tablename__ = 'points_record'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    crm_contact_id = Column(INTEGER, nullable=True)
    points_user_id = Column(INTEGER, nullable=True)
    type = Column(SMALLINT, nullable=True)
    points = Column(INTEGER, nullable=True)
    points_usable = Column(INTEGER, nullable=True)
    add_time = Column(DATETIME, nullable=True)


class PointsUser(Base):
    __tablename__ = 'points_user'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    nick = Column(NVARCHAR(16), nullable=True)
    mobile = Column(NVARCHAR(11), nullable=True)
    name = Column(NVARCHAR(20), nullable=True)
    password = Column(NVARCHAR(32), nullable=True)
    token = Column(NVARCHAR(32), nullable=True)
    url = Column(NVARCHAR(6), nullable=True)
    status = Column(INTEGER, nullable=True)
    comments = Column(NVARCHAR(128), nullable=True)


class RmList(Base):
    __tablename__ = 'rm_list'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    pay_id = Column(INTEGER, nullable=True)
    sales_id = Column(INTEGER, nullable=True)
    role = Column(NVARCHAR(20), nullable=True)
    year_month = Column(NVARCHAR(7), nullable=True)
    status = Column(INTEGER, nullable=True)
    receipt_amount = Column(DECIMAL(18, 2), nullable=True)
    is_renew = Column(SMALLINT, nullable=True)
    bussiness_cost = Column(DECIMAL(18, 2), nullable=True)
    transformer_count = Column(INTEGER, nullable=True)
    percentage = Column(DECIMAL(4, 3), nullable=True)
    role_percentage = Column(DECIMAL(4, 3), nullable=True)
    actual_price = Column(DECIMAL(18, 2), nullable=True)
    paid_price = Column(DECIMAL(18, 2), nullable=True)
    apply_date = Column(DATETIME, nullable=True)
    check_date = Column(DATETIME, nullable=True)
    approve_date = Column(DATETIME, nullable=True)
    comment = Column(NVARCHAR(128), nullable=True)
    check_comment = Column(NVARCHAR(128), nullable=True)
    review_comment = Column(NVARCHAR(128), nullable=True)
    approve_comment = Column(NVARCHAR(128), nullable=True)


class IcContract(Base):
    __tablename__ = 'ic_contract'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    sn = Column(NVARCHAR(64), nullable=True)
    project_no = Column(NVARCHAR(64), nullable=True)
    project_name = Column(NVARCHAR(64), nullable=True)
    ic_factory_id = Column(INTEGER, nullable=True)
    our_customer_id = Column(INTEGER, nullable=True)
    org_id = Column(INTEGER, nullable=True)
    sales_id = Column(INTEGER, nullable=True)
    type = Column(INTEGER, nullable=True)
    sub_type = Column(INTEGER, nullable=True)
    price = Column(DECIMAL(18, 2), nullable=True)
    payed_price = Column(DECIMAL(18, 2), nullable=True)
    start_date = Column(DATETIME, nullable=True)
    expiration_date = Column(DATETIME, nullable=True)
    signed_date = Column(DATETIME, nullable=True)
    close_date = Column(DATETIME, nullable=True)
    comments = Column(NVARCHAR(1024), nullable=True)


class IcDevice(Base):
    __tablename__ = 'ic_device'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    customer_id = Column(INTEGER, nullable=True)
    source_id = Column(INTEGER, nullable=True)
    material_id = Column(INTEGER, nullable=True)
    device_belong = Column(INTEGER, nullable=True)
    category = Column(INTEGER, nullable=True)
    cabinet_no = Column(NVARCHAR(32), nullable=True)
    number = Column(INTEGER, nullable=True)
    made_date = Column(DATETIME, nullable=True)
    comments = Column(NVARCHAR(128), nullable=True)


class IcFactory(Base):
    __tablename__ = 'ic_factory'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    level = Column(INTEGER, nullable=True)
    name = Column(NVARCHAR(64), nullable=True)
    contact = Column(NVARCHAR(32), nullable=True)
    tel = Column(NVARCHAR(32), nullable=True)
    address = Column(NVARCHAR(64), nullable=True)
    comments = Column(NVARCHAR(128), nullable=True)
    is_delete = Column(SMALLINT, nullable=True)


class IcInstock(Base):
    __tablename__ = 'ic_instock'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    no = Column(NVARCHAR(32), nullable=True)
    type = Column(INTEGER, nullable=True)
    buyer = Column(INTEGER, nullable=True)
    project_id = Column(INTEGER, nullable=True)
    storehouse = Column(INTEGER, nullable=True)
    agent_id = Column(INTEGER, nullable=True)
    in_date = Column(DATETIME, nullable=True)
    status = Column(INTEGER, nullable=True)
    comments = Column(NVARCHAR(128), nullable=True)


class IcCar(Base):
    __tablename__ = 'ic_car'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    model = Column(NVARCHAR(45), nullable=True)
    number = Column(NVARCHAR(22), nullable=True)
    start_date = Column(DATETIME, nullable=True)
    use = Column(INTEGER, nullable=True)
    oa_org_id = Column(INTEGER, nullable=True)
    oa_user_id = Column(INTEGER, nullable=True)
    insurance_due_date = Column(DATETIME, nullable=True)
    next_inspect_date = Column(DATETIME, nullable=True)
    status = Column(INTEGER, nullable=True)
    comments = Column(NVARCHAR(512), nullable=True)


class IcMaterialType(Base):
    __tablename__ = 'ic_material_type'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    category = Column(INTEGER, nullable=True)
    name = Column(NVARCHAR(32), nullable=True)
    profit_rate = Column(DECIMAL(12, 2), nullable=True)
    unmanaged_rate = Column(DECIMAL(12, 2), nullable=True)
    managed_rate = Column(DECIMAL(12, 2), nullable=True)
    branch_rate = Column(DECIMAL(12, 2), nullable=True)
    comments = Column(NVARCHAR(128), nullable=True)
    is_delete = Column(SMALLINT, nullable=True)


class IcCarCost(Base):
    __tablename__ = 'ic_car_cost'

    id = Column(INTEGER, primary_key=True, autoincrement=True)
    ic_car_id = Column(INTEGER, nullable=True)
    oa_org_id = Column(INTEGER, nullable=True)
    oa_user_id = Column(INTEGER, nullable=True)
    type = Column(INTEGER, nullable=True)
    cost = Column(DECIMAL(10, 2), nullable=True)
    date = Column(DATETIME, nullable=True)
    comments = Column(NVARCHAR(512), nullable=True)


# transformation models
class Customer(TransBase):
    __tablename__ = 'customer'
    id = Column(INTEGER, primary_key=True, autoincrement=True)
    enterprise_id = Column(INTEGER, nullable=True)
    name = Column(NVARCHAR(32), nullable=True)
    level = Column(INTEGER, default=0)
    type = Column(INTEGER, default=0)
    code = Column(NVARCHAR(32), nullable=True)
    service_enterprise_id = Column(INTEGER, default=1)
    service_staff_id = Column(INTEGER, nullable=True)
    last_service_staff_id = Column(INTEGER, nullable=True)


class Accounts(TransBase):
    __tablename__ = 'accounts'
    id = Column(INTEGER, primary_key=True, autoincrement=True)
    password = Column(NVARCHAR(128), nullable=True)
    is_superuser = Column(BOOLEAN, default=False)
    username = Column(NVARCHAR(64))
    first_name = Column(NVARCHAR(64), default='')
    last_name = Column(NVARCHAR(64), default='')
    email = Column(NVARCHAR(64), default='')
    is_staff = Column(BOOLEAN, default=0)
    is_active = Column(BOOLEAN, default=1)
    certification_status = Column(BOOLEAN, default=0)
    account_type = Column(NVARCHAR(32), nullable=True)
    date_joined = Column(DATETIME, nullable=True)
    update_time = Column(DATETIME, nullable=True)
    create_time = Column(DATETIME, nullable=True)


class Users(TransBase):
    __tablename__ = 'users'
    id = Column(INTEGER, primary_key=True, autoincrement=True)
    nickname = Column(NVARCHAR(64))
    wechat = Column(NVARCHAR(64))
    update_time = Column(DATETIME, nullable=True)
    create_time = Column(DATETIME, nullable=True)
    phone = Column(NVARCHAR(64))
    email = Column(NVARCHAR(64))
    order_rec_setting = Column(BOOLEAN, default=False)
    order_rec_status = Column(BOOLEAN, default=False)
    deleted = Column(BOOLEAN, default=False)
    account_id = Column(INTEGER)


class CustomerAdmin(TransBase):
    __tablename__ = 'customer_admin'
    id = Column(INTEGER, primary_key=True, autoincrement=True)
    user_id = Column(INTEGER)
    customer_id = Column(INTEGER)
    update_time = Column(DATETIME, nullable=True)
    create_time = Column(DATETIME, nullable=True)


class Enterprise(TransBase):
    __tablename__ = 'enterprise'
    id = Column(INTEGER, primary_key=True, autoincrement=True)
    enterprise_id = Column(NVARCHAR(64))
    name = Column(NVARCHAR(64))
    logo = Column(NVARCHAR(64))
    longitude = Column(NVARCHAR(64))
    latitude = Column(NVARCHAR(64))
    address = Column(NVARCHAR(64))
    adcode = Column(NVARCHAR(64))
    level = Column(INTEGER)
    unit_type = Column(INTEGER)
    legal_person = Column(NVARCHAR(64))
    legal_person_phone = Column(NVARCHAR(64))
    tax_num = Column(NVARCHAR(64))
    bank_account_name = Column(NVARCHAR(64))
    bank_name = Column(NVARCHAR(64))
    scale = Column(INTEGER)
    nature = Column(INTEGER)
    industry = Column(INTEGER)
    asset = Column(INTEGER)
    covered_area = Column(INTEGER)
    admin_id = Column(INTEGER)
    is_subsidiary = Column(BOOLEAN)
    parent_enterprise = Column(INTEGER)
    is_admin = Column(BOOLEAN)
