class TransFormationModel(object):
    ...


class CrmCustomer(object):
    """
        表: 账户表、用户表、客户表、客户管理员表、
            用户公司关系表、户号表、公司表、电站表
    """
    def __init__(self, idx):
        self.idx = idx + 5000
        self.tables = {
            "customer": {"id": self.idx},
            "users": {"id": self.idx},
            "enterprise": {"id": self.idx},
            "electricity_user":{"id": self.idx},
            "accounts":{"id": self.idx},
            "user_enterprise": {"id": self.idx},
            "power_station": {"id": self.idx},
        }

    def add_create_dt(self):
        self.tables["customer"].update({"enterprise_id": self.idx})
        self.tables["customer_admin"].update({"id": self.idx, "user_id": self.idx, "customer_id": self.idx})
        self.tables["electricity_user"].update({"customer_id": self.idx})
        self.tables["accounts"].update({
            "is_active": 1,
            "account_type": "customer",
            "is_staff": 0,
            "certification_status": 0,
            "password": "pbkdf2_sha256$150000$sUeSxwacxBES$3TdDGHmc4Qd7/GpKoSHGz0yaFoTQVGueFR7iBwf1ziQ=",
            "date_joined": "2020-10-26 12:13:03.703070",
        })
        self.tables["user_enterprise"].update({"id": self.idx, "user_id": self.idx})
        self.tables["power_station"].update({
            "customer_id": self.idx,
            "electricity_user_id": self.idx,
        })

    def name(self, value): #客户表、用户表、户号表、公司表
        self.tables["customer"].update({"name": value})
        self.tables["users"].update({"nickname": value})
        self.tables["enterprise"].update({"name": value})
        self.tables["electricity_user"].update({"householder": value})

    def sn(self, value): #账户表、客户表、用户公司关系表、户号表、公司表
        self.tables["accounts"].update({"username": ''.join(['EPK', str(self.idx), '-', value])})
        self.tables["customer"].update({"code": ''.join(['CM', str(self.idx),'-',value])})
        self.tables["user_enterprise"].update({"enterprise_id": ''.join(['ENT', str(self.idx), '-', value])})
        self.tables["electricity_user"].update({"number": value})
        self.tables["enterprise"].update({"enterprise_id": ''.join(['ENT', str(self.idx), '-', value])})

    def level(self, value): #客户表、公司表
        self.tables["customer"].update({"level": value})
        self.tables["enterprise"].update({"level": value})

    def unit_type(self, value): #客户表、公司表
        self.tables["customer"].update({"type": value})
        self.tables["enterprise"].update({"unit_type": value})

    def original_sales_id(self, value): #客户表
        self.tables["customer"].update({"last_service_staff_id": value})

    def sales_id(self, value): #客户表
        self.tables["customer"].update({"service_staff_id": value})

    def address(self, value): #户号表、电站表、公司表
        self.tables["electricity_user"].update({"addr": value})
        self.tables["power_station"].update({"addr": value})
        self.tables["enterprise"].update({"address": value})

    def p_capacity(self, value): #户号表
        self.tables["electricity_user"].update({"transformer_capacity": value})

    def p_real_capacity(self, value): #户号表
        self.tables["electricity_user"].update({"real_capacity": value})

    def p_vol_level(self, value): #户号表
        self.tables["electricity_user"].update({"voltage_level": value})

    def prize_type(self, value): #户号表
        self.tables["electricity_user"].update({"type": value})

    def p_our_managed(self, value): #户号表
        self.tables["electricity_user"].update({"trusteeship_num": value})

    def longitude(self, value): #户号表、公司表
        self.tables["electricity_user"].update({"longitude": value})
        self.tables["enterprise"].update({"longitude": value})

    def latitude(self, value): #户号表、公司表
        self.tables["electricity_user"].update({"latitude": value})
        self.tables["enterprise"].update({"latitude": value})

    def district(self, value): #电站表、公司表
        self.tables["enterprise"].update({"adcode": value})
        self.tables["power_station"].update({"ad_code": value})

    def city(self, value): #电站表
        self.tables["power_station"].update({"city_code": value})

    def tax_num(self, value): #公司表
        self.tables["enterprise"].update({"tax_num": value})

    def bank_account(self, value): #公司表
        self.tables["enterprise"].update({"bank_account_name": value})

    def bank_name(self, value): #公司表
        self.tables["enterprise"].update({"bank_name": value})

    def size(self, value): #公司表
        self.tables["enterprise"].update({"scale": value})

    def nature(self, value): #公司表
        self.tables["enterprise"].update({"nature": value})


class IOCustomer(object):
    """
        表: 电站表
    """
    def __init__(self, idx):
        # index = customer_id
        self.idx = idx + 5000
        self.tables = {
            "power_station": {"id": self.idx},
        }

    def add_create_dt(self):
        ...

    def times(self, value):
        self.tables["power_station"].update({"inspections_number": value})

    def start_date(self, value):
        self.tables["power_station"].update({"start_time": value})

    def end_date(self, value):
        self.tables["power_station"].update({"end_time": value})

    def et_date(self, value):
        self.tables["power_station"].update({"electric_test_time": value})

    def customize_date(self, value):
        self.tables["power_station"].update({"customize_time": value})


class CMContract(object):
    """
    表: 合同表
    """
    def __init__(self, idx):
        # index = customer_id
        self.idx = idx + 5000
        self.tables = {
            "cm_contract": {"id": self.idx},
        }

    def add_create_dt(self):
        ...

    def child_id(self, value):
        self.tables["cm_contract"].update({"child_id": value})

    def sn(self, value):
        self.tables["cm_contract"].update({"code": value})

    def price(self, value):
        self.tables["cm_contract"].update({"amount": value})

    def payed_price(self, value):
        self.tables["cm_contract"].update({"payed_price": value})

    def signed_date(self, value):
        self.tables["cm_contract"].update({"entry_date": value})

    def start_date(self, value):
        self.tables["cm_contract"].update({"effective_date": value})

    def expiration_date(self, value):
        self.tables["cm_contract"].update({"end_date": value})

    def close_date(self, value):
        self.tables["cm_contract"].update({"closed_date": value})

    def customer_id(self, value):
        self.tables["cm_contract"].update({"customer_id": value})

    def comments(self, value):
        self.tables["cm_contract"].update({"remark": value})

    def sign_org_id(self, value):
        self.tables["cm_contract"].update({"contract_party_id": value})

    def org_id(self, value):
        self.tables["cm_contract"].update({"organization_id": value})

    def customer_contact_id(self, value):
        self.tables["cm_contract"].update({"customer_contact_id": value})

    def sales_id(self, value):
        self.tables["cm_contract"].update({"salesman_id": value})

    def support_id(self, value):
        self.tables["cm_contract"].update({"support_id": value})

    def sub_type(self, value):
        self.tables["cm_contract"].update({"sub_type": value})

    def billing_period(self, value):
        self.tables["cm_contract"].update({"billing_period": value})

    def liquidated_damages(self, value):
        self.tables["cm_contract"].update({"liquidated_damages": value})

    def offer_id(self, value):
        self.tables["cm_contract"].update({"offer_id": value})

    def offer_sn(self, value):
        self.tables["cm_contract"].update({"offer_sn": value})


class OAOrg(object):
    """
    表: 公司表
    """
    def __init__(self, idx):
        self.idx = idx
        self.tables = {
            "enterprise": {
                "id": self.idx,
                "enterprise_id": 'EPK' + self.idx,
                "admin_id": self.idx + 5000
            },
        }

    def add_create_dt(self):
        ...

    def name(self, value):
        self.tables["enterprise"].update({"name": value})

    def level(self, value):
        self.tables["level"].update({(5 - value) * 5 + 120})


class OAUser(object):
    """
    表: 账户表、用户表、用户公司关系表
    """
    def __init__(self, idx):
        self.idx = idx
        self.tables = {
            "accounts": {"id": self.idx},
            "users": {"id": self.idx, "account_id": self.idx},
            "user_enterprise": {"id": self.idx, "enterprise_id": ''.join(['EPK', str(self.idx)])},
        }

    def add_create_dt(self):
        self.tables["accounts"].update({
            "is_active": 1,
            "account_type": "customer",
            "is_staff": 0,
            "certification_status": 0,
            "password": "pbkdf2_sha256$150000$sUeSxwacxBES$3TdDGHmc4Qd7/GpKoSHGz0yaFoTQVGueFR7iBwf1ziQ=",
            "date_joined": "2020-10-26 12:13:03.703070",
        })

    def name(self, value):
        self.tables["accounts"].update({"username": value})

    def nick(self, value):
        self.tables["users"].update({"nickname": value})

    def weixin_id(self, value):
        self.tables["users"].update({"wechat": value})


class CrmSource(object):
    """
    表: 户号表、电站表、电源编号表
    """
    def __init__(self, idx, customer_id):
        self.idx = idx
        self.customer_id = customer_id + 5000
        self.tables = {
            "electricity_user": {"id": self.customer_id},
            "power_station": {"id": self.customer_id},
            "electrical_info": {"id": self.idx},
        }

    def add_create_dt(self):
        self.tables["electrical_info"].update({
            "powerstation_id": self.customer_id,
            "customer_id": self.customer_id,
            "electricity_user_id": self.customer_id
        })

    def power_factor(self, value):
        self.tables["electricity_user"].update({"ep_factor": value})

    def basic_price_type(self, value):
        self.tables["electricity_user"].update({"billing_method": value})

    def line_name(self, value):
        self.tables["power_station"].update({"name": value})
        self.tables["electrical_info"].update({"incoming_line_name": value})

    def sn(self, value):
        self.tables["electrical_info"].update({"power_number": value})

    def meter_sn(self, value):
        self.tables["electrical_info"].update({"meter_number": value})

    def override(self, value):
        self.tables["electrical_info"].update({"magnification": value})

    def comments(self, value):
        self.tables["electrical_info"].update({"comment": value})


TRANSFORMATION_MAP = {
    "crm_customer": CrmCustomer,
    "io_customer": IOCustomer,
    "cm_contract": CMContract,
    "oa_org": OAOrg,
    "oa_user": OAUser,
    "crm_source": CrmSource,
}


id = 1
b = {"name":1, "sn": "dssff"}
d = {"name":2}

a = CrmCustomer(id)
c = CrmCustomer(id)
for key in b.keys():
    getattr(a, key)(b[key])
for key in d.keys():
    getattr(c, key)(d[key])
print(a.tables)
print(c.tables)