alter table users
    add is_manager tinyint(1) default 0;

CREATE TABLE `ele_team`
(
    `id`                  int(11) NOT NULL AUTO_INCREMENT,
    `team_id`             int(11)  DEFAULT NULL,
    `electricity_user_id` int(11)  DEFAULT NULL,
    `created_time`        datetime DEFAULT NULL,
    `updated_time`        datetime DEFAULT NULL,
    `deleted`             datetime DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `team_id` (`team_id`),
    KEY `electricity_user_id` (`electricity_user_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_bin;

alter table inspection_data
    add image varchar(2048) null;

alter table inspection_task
    add inspector varchar(32) null;

create table version_update
(
    id             int primary key auto_increment,
    user_id        int          null,
    version        varchar(16)  null,
    is_updated     tinyint(1) default 0,
    package_url    varchar(256) null,
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted`      tinyint(1) DEFAULT 0,
    deleted_time   datetime     null
);

alter table `order`
    modify commencement_date datetime null;

create table tariff_type
(
    id             int primary key auto_increment,
    name           varchar(64) null,
    base_prise     float      default 0,
    tip_prise      float      default 0,
    peak_prise     float      default 0,
    flat_prise     float      default 0,
    valley_prise   float      default 0,
    is_summer      tinyint(1) default 0,
    voltage_level  varchar(32) null,
    enterprise_id  int         null,
    area           varchar(64) null,
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted`      tinyint(1) DEFAULT 0,
    deleted_time   datetime    null
);

CREATE TABLE `power_station_circuit`
(
    `id`               int(11) NOT NULL AUTO_INCREMENT,
    `draw`             varchar(128) DEFAULT NULL,
    `power_station_id` int(11)      DEFAULT NULL,
    `deleted`          tinyint(1)   DEFAULT '0',
    `created_time`     datetime     DEFAULT NULL,
    `updated_time`     datetime     DEFAULT NULL,
    `deleted_time`     datetime     DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `power_station_id` (`power_station_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4;

alter table power_inspection_data
    add pressure_check varchar(32) null;

create table `customer_billing_type`
(
    id              int primary key auto_increment,
    customer_id     int         null,
    ele_user_id     int         null,
    ele_info_id     int         null,
    billing_type_id int         null,
    billing_method  varchar(32) null
);

create table sim_card
(
    id             int primary key auto_increment,
    iccid          varchar(32) null,
    sim_number     varchar(32),
    start_time     datetime    null,
    end_time       datetime    null,
    activate_time  datetime    null,
    flow           int        default 0,
    operator       varchar(32) null,
    supplier       varchar(32) null,
    status         tinyint(1) DEFAULT '0',
    `deleted`      tinyint(1) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL
);

create table `device`
(
    id             int primary key auto_increment,
    customer_id    int         null,
    `system`       varchar(32),
    deviceSerial   varchar(32) null,
    deviceName     varchar(64) null,
    name           varchar(32) null,
    deviceType     varchar(32) null,
    channal        varchar(32) null,
    status         tinyint(1) default 0,
    validateCode   varchar(32) null,
    `deleted`      tinyint(1) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL,
    type           varchar(32) null
);

create table `video_system`
(
    id             int primary key auto_increment,
    app_key        varchar(64),
    app_secret     varchar(64),
    home_url       varchar(64),
    `system`       varchar(32),
    access_token   varchar(256) null,
    customer_id    int          null,
    account_id     int          null,
    `deleted`      tinyint(1) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL
);

alter table sim_card
    add validity_period varchar(32) null;


alter table electricity_bill
    add basic_volume float default 0;
alter table electricity_bill
    add epidemic_discount float default 0;
alter table electricity_bill
    add refund_and_supplement_of_difference decimal(12, 2) default 0;
alter table electricity_bill
    add other_amount decimal(12, 2) default 0;
alter table electricity_bill
    add file varchar(256) null;
alter table electricity_bill
    add peak_md float default 0;
alter table electricity_bill
    add usual_md1 float default 0;
alter table electricity_bill
    add usual_md2 float default 0;
alter table electricity_bill
    add valley_md float default 0;

alter table task
    add score float null;
alter table task
    add appraise varchar(256) null;

create table customer_report
(

    id             int primary key auto_increment,
    customer_id    int          null,
    url            varchar(256) null,
    `year_month`   varchar(16)  null,
    report_id      varchar(16)  null,
    `deleted`      tinyint(1) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL
);

create table inspection_report
(

    id             int primary key auto_increment,
    url            varchar(256) null,
    task_id        int          null,
    `deleted`      tinyint(1) DEFAULT '0',
    `created_time` datetime   DEFAULT NULL,
    `updated_time` datetime   DEFAULT NULL,
    `deleted_time` datetime   DEFAULT NULL

);

alter table task
    add appraise_time datetime null;

alter table customer_report
    add power_number varchar(32) null;
alter table customer_report
    add basic_confirm boolean default false;
alter table customer_report
    add basic_confirm_time datetime null;
alter table customer_report
    add supper_confirm boolean default false;
alter table customer_report
    add supper_confirm_time datetime null;


alter table inspection_task
    add confirm boolean default false;

alter table notification add is_pop boolean default false;
alter table notification add `type` varchar(32) null ;