import logging

from rest_framework.response import Response

from common.third_party_api.danbing.openapi import ZYRHApi
from common.utils.views import OpenApiBaseView
from common.utils.return_structure import openapi_message

from openapi.individual_soldier.services import class_map

logger = logging.getLogger('')


class DevicesLView(OpenApiBaseView):
    def get(self, request, *args, **kwargs):
        dt = ZYRHApi.get_device_tree()
        return Response(openapi_message(msg_show="获取列表成功", **dt), status=200)


class DevicesHistoryVideosLView(OpenApiBaseView):
    def post(self, request, device_id, *args, **kwargs):
        manufacturer = request.data.get("manufacturer")
        dt = class_map(manufacturer).get_device_history_video_list(device_id)
        return Response(openapi_message(msg_show="获取列表成功", **dt), status=200)
