from common.third_party_api.danbing.openapi import ZYRHApi
from common.utils.exceptions import OpenApiServiceHandleException
from common.utils.service_code import OPEN_API_DATA_ERROR

ISMAP = {
    "0": ZYRHApi,
}


def class_map(manufacturer):
    api_class = ISMAP.get(str(manufacturer))
    if not api_class:
        raise OpenApiServiceHandleException(msg_show="参数错误",
                                            msg="params error",
                                            code=OPEN_API_DATA_ERROR)
    return api_class
