# coding=utf-8
from datetime import datetime

from utils import AESBCBEncrypt, a2b_hex, b2a_hex
aes_bcb = AESBCBEncrypt("fromhdsegtoacrel", "fromhdsegtoacrel")


def meter_dtsy(meter_id):
    dtsy = """
    <meter id="{meter_id}" name="S1:1:DTSY">
        <function id="EPI" error="">5.41</function>
        <function id="EPIJ" error="">0.00</function>
        <function id="EPIF" error="">4.52</function>
        <function id="EPIP" error="">0.00</function>
        <function id="EPIG" error="">0.89</function>
        <function id="Ua" error="">235.50</function>
        <function id="Ub" error="">235.50</function>
        <function id="Uc" error="">235.60</function>
        <function id="Ia" error="">0.04</function>
        <function id="Ib" error="">0.04</function>
        <function id="Ic" error="">0.04</function>
        <function id="Uab" error="">408.00</function>
        <function id="Ubc" error="">408.00</function>
        <function id="Uca" error="">408.10</function>
        <function id="Pt" error="">1.00</function>
        <function id="Ct" error="">100.00</function>
        <function id="Pa" error="">0.01</function>
        <function id="Pb" error="">0.01</function>
        <function id="Pc" error="">0.01</function>
        <function id="P" error="">0.02</function>
        <function id="Qa" error="">0.00</function>
        <function id="Qb" error="">0.00</function>
        <function id="Qc" error="">0.00</function>
        <function id="Q" error="">0.00</function>
        <function id="Sa" error="">0.01</function>
        <function id="Sb" error="">0.01</function>
        <function id="Sc" error="">0.01</function>
        <function id="S" error="">0.03</function>
        <function id="Pfa" error="">0.00</function>
        <function id="Pfb" error="">0.00</function>
        <function id="Pfc" error="">0.00</function>
        <function id="Pf" error="">0.00</function>
        <function id="Fr" error="">50.02</function>
        <function id="MD" error="">0.604</function>
        <function id="Balance" error="">32.28</function>
    </meter>
    """.format(meter_id=meter_id)
    return dtsy


def meter_ddsy(meter_id):
    ddsy = """
    <meter id="{meter_id}" name="S2:2:DDSY">
        <function id="EPI" error="">1.38</function>
        <function id="EPIJ" error="">0.00</function>
        <function id="EPIF" error="">1.22</function>
        <function id="EPIP" error="">0.00</function>
        <function id="EPIG" error="">0.16</function>
        <function id="U" error="">236.20</function>
        <function id="I" error="">0.31</function>
        <function id="P" error="">0.07</function>
        <function id="Q" error="">0.01</function>
        <function id="S" error="">0.08</function>
        <function id="PF" error="">0.93</function>
        <function id="F" error="">50.01</function>
        <function id="Balance" error="">6.73</function>
    </meter>
    """.format(meter_id=meter_id)
    return ddsy


def xml_identify(building_id, gateway_id):
    xml = """
    <?xml version="1.0" encoding="utf-8"?>
    <root>
        <common>
            <building_id>{building_id}</building_id>
            <gateway_id>{gateway_id}</gateway_id>
            <type>id_validate</type>
        </common>
        <id_validate operation="md5">
            <md5>D38DD4B33BF37EEA7C8E0336A52F576C</md5>
        </id_validate>
    </root>
    """.format(building_id=building_id,
               gateway_id=gateway_id)
    xml = xml.replace("\n", "")
    xml = xml.replace("    ", "")
    body = xml.encode()
    return body


def xml_power(building_id, gateway_id, meter_num):
    s = """
    <?xml version="1.0" encoding="utf-8"?>
    <root>
        <common>
            <building_id>{building_id}</building_id>
            <gateway_id>{gateway_id}</gateway_id>
            <type>energy_data</type>
        </common>
        <data operation="report">
            <time>{now}</time>
            <energy_items></energy_items>
            <meters total="{meter_num}">
    """.format(building_id=building_id,
               gateway_id=gateway_id,
               now=datetime.now().strftime("%Y%m%d%H%M%S"),
               meter_num=meter_num)
    for i in range(meter_num):
        meter_id = "01" + str(i+1).zfill(3)
        s += meter_ddsy(meter_id)
    s += """
            </meters>
        </data>
    </root>
    """
    s = s.replace("\n", "")
    s = s.replace("    ", "")
    data = a2b_hex(aes_bcb.encrypt(s))
    return data


if __name__ == '__main__':
    msg = xml_power("PowerKeeper", "DigitalCenter", 200)

