from django_filters import rest_framework as filter


class PlanFilter(filter.FilterSet):
    customer = filter.CharFilter(method="get_customer")
    customer_id = filter.CharFilter(method="get_customer_id")

    def get_customer(self, queryset, name, value):
        if value:
            queryset = queryset.filter(customer__name__icontains=value)
        return queryset

    def get_customer_id(self, queryset, name, value):
        if value:
            queryset = queryset.filter(customer_id=value)
        return queryset


class TaskFilter(filter.FilterSet):
    status = filter.CharFilter(method="get_status")
    type = filter.CharFilter(method="get_type")
    user_id = filter.CharFilter(method="get_user")
    keyword = filter.CharFilter(method="get_content")
    plan_id = filter.CharFilter(method="get_plan")
    code_id = filter.CharFilter(method="get_code")

    def get_plan(self, queryset, name, value):
        if value:
            queryset = queryset.filter(plan_id=value)
        return queryset

    def get_code(self, queryset, name, value):
        if value:
            queryset = queryset.filter(code_id=value)
        return queryset

    def get_status(self, queryset, name, value):
        if value:
            queryset = queryset.filter(status=value)
        return queryset

    def get_type(self, queryset, name, value):
        if value:
            queryset = queryset.filter(type=value)
        return queryset

    def get_user(self, queryset, name, value):
        if value:
            queryset = queryset.filter(submitter_id=value)
        return queryset

    def get_content(self, queryset, name, value):
        if value:
            queryset = queryset.filter(customer__customer__name__icontains=value)
        return queryset


class SignInFilter(filter.FilterSet):
    user_id = filter.CharFilter(method="get_user")
    customer_id = filter.CharFilter(method="get_customer")
    keyword = filter.CharFilter(method="get_keyword")

    def get_user(self, queryset, name, value):
        if value:
            queryset = queryset.filter(user_id=value)
        return queryset

    def get_customer(self, queryset, name, value):
        if value:
            queryset = queryset.filter(customer__customer_id=value)
        return queryset

    def get_keyword(self, queryset, name, value):
        if value:
            queryset = queryset.filter(customer__customer__name__icontains=value)
        return queryset
