from django.db import models

# Create your models here.
from common.utils.models import BaseModel
from common.accounts.models import Users, Enterprise
from console.organizations.models import Organization


class CrmUsers(BaseModel):
    user = models.ForeignKey(to=Users, on_delete=models.SET_NULL, null=True, help_text="营销人员")
    enterprise = models.ForeignKey(to=Enterprise, on_delete=models.SET_NULL, null=True, help_text="所属公司")

    class Meta:
        db_table="crm_users"


class CrmTeams(BaseModel):
    name = models.CharField(max_length=64, help_text="名称")
    leader = models.ForeignKey(to=Users, on_delete=models.SET_NULL, null=True, help_text="团队所有者 id")
    crm_user = models.ForeignKey(to=CrmUsers, on_delete=models.SET_NULL,
                                 null=True, help_text="团队所有者 crmUserId")
    enterprise = models.ForeignKey(to=Enterprise, on_delete=models.SET_NULL, null=True, help_text="所属公司")
    class Meta:
        db_table="crm_teams"

