from django.urls import path

from crm.crm_customer import views

urlpatterns = [
    path("", views.CrmCustomerLView.as_view()),
    path("/<int:customer_id>/distribute", views.CrmCustomerDistributeUView.as_view()),
    path("/<int:customer_id>/remarks", views.CrmCustomerRemarkLView.as_view()),
    path("/clue", views.CrmCustomerClueLCView.as_view()),
    path("/clue/<int:clue_id>", views.CrmCustomerClueRUDView.as_view()),
    path("/clue/<int:clue_id>/approve", views.CrmCustomerClueApproveView.as_view()),
    path("/portrait", views.CrmCustomerPortraitView.as_view()),
    path("/remark/create", views.CustomerRemarkView.as_view()),
    path("/remark/<int:id>/delete", views.CustomerRemarkView.as_view()),
    path("/remark/<int:id>/edit", views.CustomerRemarkView.as_view()),
    path("/remark/<int:id>/info", views.CustomerRemarkView.as_view()),
    path("/remarks", views.CustomerRemarkView.as_view()),
]
