from rest_framework import status
from rest_framework.response import Response

from common.utils.views import BaseApiView
from common.utils.views import general_message

from crm.crm_customer.serializers import (CrmCustomerClueSerializer, CrmCustomerClueUSerializer)
from crm.crm_customer.services import crm_customer_service

from crm.plan.models import UserMessage, VisitRecord

from crm.crm_app.serializers import (UserMessageSerializer, CustomerVisitRecordSerializer,
                                     CustomerOperationRecordSerializer)

from crm.crm_app.filters import VisitRecordFilter

from crm.crm_statistic.services import StatisticService

from crm.plan.models import SignIn, CustomerOperationRecord


class CrmCustomerLView(BaseApiView):
    def get(self, request, *args, **kwargs):
        query = request.GET.copy()
        page = request.GET.get("page", 1)
        page_size = request.GET.get("page_size", 10)
        rst, count = crm_customer_service.get_customers(self.enterprise_ids, self.user.id, **query)
        data = general_message(list=rst, count=count, page=page, page_size=page_size)
        return Response(data, status=status.HTTP_200_OK)


class AppCrmCustomerLView(BaseApiView):
    def get(self, request, *args, **kwargs):
        query = request.GET.copy()
        rst, count = crm_customer_service.get_customers_app(self.enterprise_ids, self.user.id, **query)
        data = general_message(list=rst, count=count)
        return Response(data, status=status.HTTP_200_OK)


class CrmCustomerClueLCView(BaseApiView):
    def post(self, request, *args, **kwargs):
        serializer = CrmCustomerClueSerializer(data=request.data)
        serializer.is_valid(raise_exception=True)
        clue = crm_customer_service.create_customer_clue(self.enterprise.id, self.user.id, serializer.data)
        return Response(general_message("创建成功", bean={"id": clue.id}), status=status.HTTP_200_OK)

    def get(self, request, *args, **kwargs):
        query = request.GET.copy()
        page = request.GET.get("page", 1)
        page_size = request.GET.get("page_size", 10)
        rst, count = crm_customer_service.get_customer_clue(self.enterprise_ids, **query)
        data = general_message(list=rst, count=count, page=page, page_size=page_size)
        return Response(data, status=status.HTTP_200_OK)


class CrmCustomerClueRUDView(BaseApiView):
    def get(self, request, clue_id, *args, **kwargs):
        query = request.GET.copy()
        rst = crm_customer_service.get_customer_clue_info(self.enterprise_ids, self.user.id, clue_id, **query)
        data = general_message(bean=rst)
        return Response(data, status=status.HTTP_200_OK)

    def put(self, request, clue_id, *args, **kwargs):
        serializer = CrmCustomerClueUSerializer(data=request.data)
        serializer.is_valid(raise_exception=True)
        clue = crm_customer_service.update_customer_clue(self.enterprise_ids, self.user.id, serializer.data)
        return Response(general_message("更新成功", bean=clue), status=status.HTTP_200_OK)

    def delete(self, request, clue_id, *args, **kwargs):
        crm_customer_service.del_customer_clue(self.enterprise_ids, self.user.id, clue_id)
        return Response(general_message("删除成功"), status=status.HTTP_200_OK)


class UserMessageListView(BaseApiView):
    queryset = UserMessage.objects.filter()
    serializer_class = UserMessageSerializer

    def get(self, request, *args, **kwargs):
        if not kwargs.get("id"):
            user_message = self.get_queryset().filter(user=self.user)
            serializer = self.get_serializer(user_message, many=True)
            return Response(general_message(list=serializer.data, bean={
                "unread_num": user_message.filter(is_read=False).count()
            }))
        user_message = self.get_queryset().filter(id=kwargs.get("id")).first()
        serializer = self.get_serializer(user_message)
        return Response(general_message(bean=serializer.data))


class CustomerVisitRecordView(BaseApiView):
    queryset = VisitRecord.objects.filter()
    serializer_class = CustomerVisitRecordSerializer
    filter_class = VisitRecordFilter

    def get(self, request, *args, **kwargs):
        queryset = self.filter_queryset(self.get_queryset()).filter(user=self.user)
        if not kwargs.get("id"):
            serializer = self.get_serializer(queryset, many=True)
            return Response(general_message(list=serializer.data))
        instance = queryset.filter(id=kwargs.get("id")).first()
        serializer = self.get_serialzier(instance)
        return Response(general_message(bean=serializer.data))


class MessageRedView(BaseApiView):
    def put(self, request, *args, **kwargs):
        UserMessage.objects.filter(id=kwargs.get("id")).update(is_read=True)
        return Response(general_message("已读成功"))


class PersonRankView(BaseApiView):
    def get(self, request, *args, **kwargs):
        service = StatisticService()
        return Response(general_message(bean=service.get_rank(self.user.id)))


class CustomerSignInNumber(BaseApiView):
    def get(self, request, *args, **kwargs):
        return Response(
            general_message(bean={
                "count": SignIn.objects.filter(customer_id=request.GET.get("customer_id")
                                               ).count()}))


class CustomerReporationView(BaseApiView):
    def get(self, request, *args, **kwargs):
        queryset = CustomerOperationRecord.objects.filter(customer_id=request.GET.get("customer_id"))
        serializer = CustomerOperationRecordSerializer(queryset, many=True)
        return Response(general_message(list=serializer.data))
