from django.urls import path

from crm.crm_customer import views
from crm.crm_app import views as app_views

urlpatterns = [
    path("/customer", views.AppCrmCustomerLView.as_view()),
    path("/messages", app_views.UserMessageListView.as_view()),
    path("/message/<int:id>", app_views.UserMessageListView.as_view()),
    path("/visit_record", app_views.CustomerVisitRecordView.as_view()),
    path("/visit_record/<int:id>", app_views.CustomerVisitRecordView.as_view()),
    path("/message/<int:id>/read", app_views.MessageRedView.as_view()),
    path("/person_rank", app_views.PersonRankView.as_view()),
    path("/customer/signin_count", app_views.CustomerSignInNumber.as_view()),
    path("/customer/operation_record", app_views.CustomerReporationView.as_view())
]
