from rest_framework import serializers as serializer

from crm.plan.models import UserMessage, VisitRecord

from crm.plan.models import CustomerOperationRecord


class UserMessageSerializer(serializer.ModelSerializer):
    title = serializer.SerializerMethodField()
    sender = serializer.SerializerMethodField()
    end_time = serializer.SerializerMethodField()
    customer_id = serializer.SerializerMethodField()
    task_id = serializer.SerializerMethodField()
    content = serializer.SerializerMethodField()
    type = serializer.SerializerMethodField()
    status = serializer.SerializerMethodField()
    contact = serializer.SerializerMethodField()
    contact_phone = serializer.SerializerMethodField()
    customer_name = serializer.SerializerMethodField()

    def get_status(self, obj):
        return obj.message.status

    def get_contact(self, obj):
        return obj.message.contact

    def get_contact_phone(self, obj):
        return obj.message.contact_phone

    def get_customer_name(self, obj):
        return obj.message.customer.customer.name

    def get_title(self, obj):
        return obj.message.title

    def get_type(self, obj):
        return obj.message.type

    def get_sender(self, obj):
        return obj.message.creater.nickname

    def get_end_time(self, obj):
        return obj.message.limit_time

    def get_customer_id(self, obj):
        return obj.message.customer_id

    def get_task_id(self, obj):
        return obj.message.task_id

    def get_content(self, obj):
        return obj.message.content

    class Meta:
        model = UserMessage
        fields = ("id", "title", "sender", "created_time", "end_time", "customer_id", "task_id", "content",
                  "type", "is_read", "status", "contact", "contact_phone", "customer_name")


class CustomerVisitRecordSerializer(serializer.ModelSerializer):
    customer = serializer.SerializerMethodField()

    def get_customer(self, obj):
        return {
            "id": obj.customer.id,
            "name": obj.customer.customer.name
        } if obj.customer else None

    class Meta:
        model = VisitRecord
        fields = ("id", "customer", "content", "visit_time")


class CustomerOperationRecordSerializer(serializer.ModelSerializer):
    class Meta:
        model = CustomerOperationRecord
        fields = ("id", "plan_id", "content", "created_time")
