# Create your views here.
from rest_framework.response import Response

from common.utils.return_structure import error_message, general_message
from common.utils.views import BaseApiView
from console.powerstation.models import PowerStation
from console.wechat.serializers import StatisticSerializer


class StatisticView(BaseApiView):
    queryset = PowerStation.objects.filter()
    serializer_class = StatisticSerializer

    def get(self, request, *args, **kwargs):
        station = self.get_queryset().filter(
            id=request.GET.get("station_id")).first()
        if not station:
            return Response(
                error_message(
                    msg_show="电站{}不存在".format(request.GET.get("station_id"))))
        serializer = self.get_serializer(station)
        return Response(general_message(bean=serializer.data))
