from django.urls import path

from . import views

urlpatterns = [
    path("/create_device", views.CreateDeviceView.as_view()),
    path("/create_video_system", views.CreateVideoSystemView.as_view()),
    path("/list_device", views.DeviceListView.as_view()),
    path("/device/<int:id>/video_url", views.VideoUrlView.as_view()),
    path("/device_entities", views.DeviceEntityListView.as_view()),
    path("/bind_device", views.BindDeviceView.as_view()),
    path("/device/<int:id>", views.DeviceView.as_view()),
    path("/device/<int:id>/bind_user", views.DeviceBindUser.as_view()),
    path("/video_system", views.VideoSystemListView.as_view()),
    path("/video_system/<int:id>", views.VideoSystemView.as_view()),
    path("/entity/video_url", views.EntityVideoUrlView.as_view()),
    path("/<int:user_id>/video_url", views.UserVideoUrlView.as_view())
]
