from django.db import models

# Create your models here.
from common.utils.models import BaseModel

from common.accounts.models import Accounts
from console.customer.models import Customer

from common.accounts.models import Users

from console.powerstation.models import PowerStation

SYSTEM_MAP = (("1", "乐橙云"), ("2", "萤石云"))
TYPE_MAP = (("1", "头盔式摄像头"), ("2", "固定摄像头"))


class Device(BaseModel):
    deviceSerial = models.CharField(max_length=64, help_text="设备序列号")
    channal = models.CharField(max_length=32, help_text="信道")
    name = models.CharField(max_length=32, null=True, help_text="名称")
    deviceName = models.CharField(max_length=64, help_text="设备名称", null=True)
    deviceType = models.CharField(max_length=64, help_text="设备类型", null=True)
    customer = models.ForeignKey(to=Customer,
                                 on_delete=models.SET_NULL,
                                 null=True,
                                 related_name="customer_device")
    system = models.ForeignKey(to="VideoSystem", on_delete=models.SET_NULL, null=True, help_text="所属平台",
                               db_column="system_id")
    status = models.BooleanField(null=True, help_text="设备状态")
    validateCode = models.CharField(max_length=32,
                                    null=True,
                                    help_text="设备验证码")
    type = models.CharField(max_length=32, choices=TYPE_MAP, null=True, help_text="类型")
    user = models.ForeignKey(to=Users, on_delete=models.SET_NULL, null=True, help_text="绑定人员")
    station = models.ForeignKey(to=PowerStation, on_delete=models.SET_NULL, null=True)

    class Meta:
        db_table = "device"


class VideoSystem(BaseModel):
    app_key = models.CharField(max_length=64, help_text="所属平台key")
    app_secret = models.CharField(max_length=64, help_text="所属平台secrect")
    home_url = models.CharField(max_length=64, help_text="平台地址")
    system = models.CharField(max_length=32,
                              help_text="所属平台",
                              choices=SYSTEM_MAP)
    access_token = models.CharField(max_length=256, null=True, help_text="平台登录token")
    name = models.CharField(max_length=32, null=True)
    customer = models.ForeignKey(to=Customer,
                                 on_delete=models.SET_NULL,
                                 null=True,
                                 related_name="customer_video_account")
    account = models.ForeignKey(to=Accounts,
                                on_delete=models.SET_NULL,
                                null=True)

    class Meta:
        db_table = "video_system"
