from django.db.models import Q
from django_filters import rest_framework as filter


class DeviceFilter(filter.FilterSet):
    system = filter.CharFilter(method="get_system")
    type = filter.CharFilter(method="get_type")
    keyword = filter.CharFilter(method="get_keyword")

    def get_keyword(self, queryset, name, value):
        if value:
            queryset = queryset.filter(Q(name__icontains=value) |
                                       Q(id__icontains=value) |
                                       Q(user__nickname__icontains=value) |
                                       Q(customer__name__icontains=value) |
                                       Q(station__name__icontains=value))
        return queryset

    def get_type(self, queryset, name, value):
        if value:
            queryset = queryset.filter(type=value)
        return queryset

    def get_system(self, queryset, name, value):
        if value:
            queryset = queryset.filter(system=value)
        return queryset


class VideoSystemFilter(filter.FilterSet):
    customer_id = filter.CharFilter(method="get_customer")

    def get_customer(self, queryset, name, value):
        if value:
            queryset = queryset.filter(customer_id=value)
        return queryset
