from django.conf.urls import url
from django.urls import include, re_path
from django.views.static import serve

from etc.settings.base import EXPORT_ROOT, UPLOAD_FILE_PATH

urlpatterns = [
    re_path(r'export/(?P<path>.*)', serve, {"document_root": EXPORT_ROOT}),
    re_path(r'upload/(?P<path>.*)', serve,
            {"document_root": UPLOAD_FILE_PATH}),
    url(r'^console/', include("console.test.urls")),
    url(r'^console/', include("console.inspection.urls")),
    url(r'^console/OMS/customer', include("console.customer.urls")),
    url(r'^console/OMS/electricityuser/',
        include("console.electricityuser.urls")),
    url(r'^console/OMS/powerstation/', include("console.powerstation.urls")),
    url(r'^console/OMS/team/', include("console.team.urls")),
    url(r'^console/learning/', include("console.learningcenter.urls")),
    url(r"^console/OMS/task", include("console.task.urls")),
    url(r"^console/OMS/order", include("console.order.urls")),
    url(r'^console/OMS/equipment', include("console.equipment.urls")),
    url(r'^console/OMS/contract', include("console.contract.urls")),
    url(r'^console/OMS/dashboard/', include("console.dashboard.urls")),
    url(r'^console/custom_info/', include("console.user_center.urls")),
    url(r'^console/organizations/', include("console.organizations.urls")),
    url(r'^console/APP', include("console.APP.urls")),
    url(r'^console/OMS/dictionary', include("console.dictionary.urls")),
    url(r'^console/OMS/electricalinfo',
        include("console.electrical_info.urls")),
    url(r'^console/wechat', include("console.wechat.urls")),
    url(r"^console/home_page", include("console.home_page.urls")),
    url(r"^console/circuit_file", include("console.circuit_diagram.urls")),
    url(r'^console/message', include("console.message.urls")),
    url(r'^console/monitor', include("console.monitor.urls")),
    url(r"^console/electricity_bill",
        include("console.electricity_bill.urls")),
    url(r"^console/customer_system", include("console.customer_system.urls")),
    url(r"^console/video_management", include("console.video_management.urls")),
    url(r"^console/sim_card", include("console.sim_card.urls")),
]
