from rest_framework.renderers import JSONRenderer, BrowsableAPIRenderer
from rest_framework_jwt.authentication import JSONWebTokenAuthentication
from rest_framework.permissions import IsAuthenticated
from rest_framework.generics import GenericAPIView
from rest_framework.response import Response
from rest_framework import status
from drf_yasg.utils import swagger_auto_schema
from drf_yasg import openapi

from common.utils.pagination import CustomPageNumberPagination

from .serializers import TestSerializers


class Test(GenericAPIView):
    pagination_class = CustomPageNumberPagination
    permission_classes = (IsAuthenticated, )
    authentication_classes = (JSONWebTokenAuthentication, )
    serializer_class = TestSerializers
    renderer_classes = (JSONRenderer, BrowsableAPIRenderer)

    @swagger_auto_schema(
        operation_description="获取任务列表信息",
        manual_parameters=[
            openapi.Parameter("page",
                              openapi.IN_QUERY,
                              description="页码",
                              type=openapi.TYPE_INTEGER,
                              required=False),
            openapi.Parameter("page_size",
                              openapi.IN_QUERY,
                              description="每页数量",
                              type=openapi.TYPE_INTEGER,
                              required=False),
        ],
        responses={status.HTTP_200_OK: TestSerializers()},
        tags=['api-test'],
    )
    def get(self, request, *args, **kwargs):
        data = [
            {
                "user": "test1",
                "age": 18
            },
            {
                "user": "test2",
                "age": 22
            },
        ]
        serializer = TestSerializers(data=data)
        serializer.is_valid(raise_exception=True)
        ret = {'requests': serializer.data}
        return Response(ret, status=200)
