from common.utils.exceptions import ValidationError
from .models import Team, TeamSchedule, HandOverRecord


class TeamQuerySet(object):
    @property
    def get_all_team(self):
        return Team.objects.filter(deleted=False)


class TeamRepo(object):
    def get_team(self, pk):
        queryset = Team.objects.filter(deleted=False, id=pk).order_by("id")
        if not queryset.exists():
            raise ValidationError("没有找到该id")
        return queryset.first()

    def get_teams(self, pk_list):
        queryset = Team.objects.filter(deleted=False,
                                       id__in=pk_list).order_by("id")
        if not queryset.exists():
            raise ValidationError("没有找到id")
        return queryset.first()


class TeamScheduleQuerySet(object):
    @property
    def get_all_teamschedule(self):
        return TeamSchedule.objects.filter(deleted=False).order_by("id")


class TeamScheduleRepo(object):
    def get_team_schedule(self, pk):
        queryset = TeamSchedule.objects.filter(deleted=False, id=pk)
        if not queryset.exists():
            raise ValidationError("没有找到该id")
        return queryset.first()


class HandOverRecordQuerySet(object):
    @property
    def get_all_handoverrecord(self):
        return HandOverRecord.objects.filter(deleted=False).order_by("id")


class HandOverRecordRepo(object):
    def get_handoverrecord(self, pk):
        queryset = HandOverRecord.objects.filter(deleted=False, id=pk)
        if not queryset.exists():
            raise ValidationError("没有找到该id")
        return queryset.first()


team_queryset = TeamQuerySet()
team_repo = TeamRepo()
teamschedule_queryset = TeamScheduleQuerySet()
teamschedule_repo = TeamScheduleRepo()
handoverrecord_queryset = HandOverRecordQuerySet()
handoverrecord_repo = HandOverRecordRepo()
