from datetime import datetime

from django_filters import rest_framework as filter


class TeamFilter(filter.FilterSet):
    name = filter.CharFilter(method='get_team_name')
    type = filter.NumberFilter(method='get_team_type')

    def get_team_name(self, queryset, name, value):
        if value:
            queryset = queryset.filter(name__contains=value)
        return queryset

    def get_team_type(self, queryset, name, value):
        if value:
            queryset = queryset.filter(type=value)
        return queryset


class TeamScheduleFilter(filter.FilterSet):
    team_name = filter.CharFilter(method='get_team_name')
    team = filter.NumberFilter(method='get_team')
    schedule_date = filter.CharFilter(method='get_schedule_date')

    def get_team(self, queryset, name, value):
        if value:
            queryset = queryset.filter(team_id=value)
        return queryset

    def get_team_name(self, queryset, name, value):
        if value:
            queryset = queryset.filter(team__name__contains=value)
        return queryset

    def get_schedule_date(self, queryset, name, value):
        if value:
            date = datetime.strptime(value, "%Y-%m")
            year = date.year
            month = date.month
            queryset = queryset.filter(schedule_date__year=year,
                                       schedule_date__month=month)
        return queryset


class HandOverFilter(filter.FilterSet):
    transfer_team = filter.CharFilter(method='get_transfer_team')
    recieve_team = filter.CharFilter(method='get_recieve_team')
    handover_time = filter.CharFilter(method='get_handover_time')
    transfer_team_id = filter.NumberFilter(method='get_transfer_team_id')
    recieve_team_id = filter.NumberFilter(method='get_recieve_team_id')

    def get_transfer_team(self, queryset, name, value):
        if value:
            queryset = queryset.filter(transfer_team__name__contains=value)
        return queryset

    def get_recieve_team(self, queryset, name, value):
        if value:
            queryset = queryset.filter(recieve_team__name__contains=value)
        return queryset

    def get_transfer_team_id(self, queryset, name, value):
        if value:
            queryset = queryset.filter(transfer_team__id=value)
        return queryset

    def get_recieve_team_id(self, queryset, name, value):
        if value:
            queryset = queryset.filter(recieve_team__id=value)
        return queryset

    def get_handover_time(self, queryset, name, value):
        if value:
            date = datetime.strptime(value, "%Y-%m-%d")
            year = date.year
            month = date.month
            day = date.day
            queryset = queryset.filter(handover_time__year=year,
                                       handover_time__month=month,
                                       handover_time__day=day)
        return queryset
