from rest_framework import serializers as serializer

from console.sim_card.models import SimCard

from console.monitor.models import MonitorDevices


class SimCardSerializer(serializer.ModelSerializer):
    imei = serializer.SerializerMethodField()
    customer = serializer.SerializerMethodField()
    power_number = serializer.SerializerMethodField()

    def get_imei(self, obj):
        power_device = MonitorDevices.objects.filter(sim=obj.sim_number).first()
        return power_device.imei if power_device else None


    def get_customer(self, obj):
        power_device = MonitorDevices.objects.filter(sim=obj.sim_number).first()
        return power_device.monitor_point.customer.name if \
            power_device and power_device.monitor_point and power_device.monitor_point.customer else None

    def get_power_number(self, obj):
        power_device = MonitorDevices.objects.filter(sim=obj.sim_number).first()
        return power_device.monitor_point.electricity_user.number if \
            power_device and power_device.monitor_point and power_device.monitor_point.electricity_user else None

    class Meta:
        model = SimCard
        fields = ("id", "iccid", "sim_number", "start_time", "end_time", "activate_time", "flow",
                  "operator", "supplier", "status", "validity_period", "imei", "customer", "power_number")
