from django.db import models

# Create your models here.
from common.utils.models import BaseModel


class SimCard(BaseModel):
    iccid = models.CharField(max_length=32, null=True)
    sim_number = models.CharField(max_length=32, help_text="sim卡号")
    start_time = models.DateTimeField(null=True, help_text="开户时间")
    end_time = models.DateTimeField(null=True, help_text="到期时间")
    activate_time = models.DateTimeField(null=True, help_text="激活时间")
    flow = models.IntegerField(default=0, help_text="套餐流量")
    operator = models.CharField(max_length=32, null=True, help_text="运营商")
    supplier = models.CharField(max_length=32, null=True, help_text="供应商")
    status = models.BooleanField(default=False, help_text="状态")
    validity_period = models.CharField(max_length=32, null=True)

    class Meta:
        db_table = "sim_card"
